/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.confluence;

import com.atlassian.crowd.acceptance.tests.applications.confluence.ConfluenceAcceptanceTestCase;

public class ConfluenceUserBrowserTest
extends ConfluenceAcceptanceTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.adminLoginToConfluence();
    }

    public void testBrowseUsers() {
        this.gotoBrowseUsers();
        this.clickLinkWithText("Show all users");
        this.assertTextPresent("confluence-admin");
        this.assertTextPresent("Confluence Administrator");
        this.assertTextPresent("connieadmin@example.com");
        this.assertTextPresent("admin");
        this.assertTextPresent("Super User");
        this.assertTextPresent("admin@example.com");
    }

    public void testSearchUsersViaEmail() {
        this.gotoBrowseUsers();
        this.setWorkingForm("searchusers");
        this.setTextField("emailTerm", "connieadmin@example.com");
        this.submit();
        this.assertTextPresent("confluence-admin");
        this.assertTextPresent("Confluence Administrator");
        this.assertTextPresent("connieadmin@example.com");
    }

    public void testSearchUsersViaEmailFullnameAndUsername() {
        this.gotoBrowseUsers();
        this.accessAdminFeature();
        this.setWorkingForm("searchusers");
        this.setTextField("emailTerm", "connieadmin@example.com");
        this.setTextField("fullnameTerm", "Confluence Administrator");
        this.setTextField("usernameTerm", "confluence-admin");
        this.submit();
        this.assertTextPresent("confluence-admin");
        this.assertTextPresent("Confluence Administrator");
        this.assertTextPresent("connieadmin@example.com");
    }

    public void testViewUser() {
        this.gotoBrowseUsers();
        this.accessAdminFeature();
        this.clickLinkWithText("Show all users");
        this.clickUsernameLink("confluence-admin");
        this.assertTextPresent("View User: confluence-admin");
        this.assertTextPresent("confluence-admin");
        this.assertTextPresent("Confluence Administrator");
        this.assertTextPresent("connieadmin@example.com");
        this.assertTextPresent("confluence-administrators");
        this.assertTextPresent("confluence-users");
        this.assertTextNotPresent("crowd-administrators");
        this.assertLinkPresentWithText("View Profile");
        this.assertLinkPresentWithText("Edit Groups");
        this.assertLinkPresentWithText("Edit Details");
        this.assertLinkPresentWithText("Set Password");
        this.assertLinkNotPresentWithText("Remove");
    }
}

