/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.confluence;

import com.atlassian.crowd.acceptance.tests.applications.confluence.ConfluenceAcceptanceTestCase;

public class ConfluenceSingleSignOnTest
extends ConfluenceAcceptanceTestCase {
    protected static final String CROWD_ONLY_USER_USERNAME = "crowd-only";
    protected static final String CONFLUENCE_ONLY_USER_USERNAME = "confluence-admin";
    protected static final String DUAL_ACCESS_USER_USERNAME = "crowd-confluence";
    protected static final String PASSWORD = "password";

    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("crowdconfluencesso.xml");
        this.logoutFromCrowd();
        this.logoutFromConfluence();
        this.setScriptingEnabled(false);
    }

    public void testLoginToCrowdConsequentlyLoggedInToConfluence() {
        this.log("Running testLoginToCrowdConsequentlyLoggedInToConfluence");
        this.logoutFromCrowd();
        this.logoutFromConfluence();
        String crowdUser = this.loginToCrowd("admin", "admin");
        ConfluenceSingleSignOnTest.assertNotNull((Object)crowdUser);
        String confluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertEquals((String)crowdUser, (String)confluenceUser);
        crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        ConfluenceSingleSignOnTest.assertEquals((String)crowdUser, (String)confluenceUser);
    }

    public void testLoginToConfluenceConsequentlyLoggedInToCrowd() {
        this.log("Running testLoginToConfluenceConsequentlyLoggedInToCrowd");
        this.logoutFromCrowd();
        this.logoutFromConfluence();
        String confluenceUser = this.loginToConfluence("admin", "admin");
        ConfluenceSingleSignOnTest.assertNotNull((Object)confluenceUser);
        String crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        ConfluenceSingleSignOnTest.assertEquals((String)confluenceUser, (String)crowdUser);
        confluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertEquals((String)confluenceUser, (String)crowdUser);
    }

    public void testLogoutOfCrowdConsequentlyLoggedOutOfConfluence() {
        this.log("Running testLogoutOfCrowdConsequentlyLoggedOutOfConfluence");
        String crowdUser = this.loginToCrowd("admin", "admin");
        ConfluenceSingleSignOnTest.assertNotNull((Object)crowdUser);
        String confluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertNotNull((Object)confluenceUser);
        this.logoutFromCrowd();
        confluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertNull((Object)confluenceUser);
    }

    public void testLogoutOfConfluenceConsequentlyLoggedOutOfCrowd() {
        this.log("Running testLogoutOfConfluenceConsequentlyLoggedOutOfCrowd");
        String crowdUser = this.loginToCrowd("admin", "admin");
        ConfluenceSingleSignOnTest.assertNotNull((Object)crowdUser);
        String confluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertNotNull((Object)confluenceUser);
        this.logoutFromConfluence();
        crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        ConfluenceSingleSignOnTest.assertNull((Object)crowdUser);
    }

    public void testSwitchUserInCrowdConsequentlySwitchesUserInConfluence() {
        this.log("Running testSwitchUserInCrowdConsequentlySwitchesUserInConfluence");
        String crowdUser = this.loginToCrowd("admin", "admin");
        ConfluenceSingleSignOnTest.assertNotNull((Object)crowdUser);
        String confluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertNotNull((Object)confluenceUser);
        this.logoutFromCrowd();
        String newCrowdUser = this.loginToCrowd(DUAL_ACCESS_USER_USERNAME, PASSWORD);
        ConfluenceSingleSignOnTest.assertNotSame((Object)newCrowdUser, (Object)crowdUser);
        String newConfluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertEquals((String)newCrowdUser, (String)newConfluenceUser);
    }

    public void testSwitchUserInConfluenceConsequentlySwitchesUserInCrowd() {
        this.log("Running testSwitchUserInConfluenceConsequentlySwitchesUserInCrowd");
        String crowdUser = this.loginToCrowd("admin", "admin");
        ConfluenceSingleSignOnTest.assertNotNull((Object)crowdUser);
        String confluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertNotNull((Object)confluenceUser);
        this.logoutFromConfluence();
        String newConfluenceUser = this.loginToConfluence(DUAL_ACCESS_USER_USERNAME, PASSWORD);
        ConfluenceSingleSignOnTest.assertNotSame((Object)newConfluenceUser, (Object)confluenceUser);
        String newCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        ConfluenceSingleSignOnTest.assertEquals((String)newCrowdUser, (String)newConfluenceUser);
    }

    public void testLoginToConfluenceConsequentlyLoggedInToCrowd_unauthorisedFailure() {
        this.log("Running testLoginToConfluenceConsequentlyLoggedInToCrowd_unauthorisedFailure");
        this.logoutFromCrowd();
        this.logoutFromConfluence();
        String confluenceUser = this.loginToConfluence(CONFLUENCE_ONLY_USER_USERNAME, "admin");
        ConfluenceSingleSignOnTest.assertNotNull((Object)confluenceUser);
        String crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        ConfluenceSingleSignOnTest.assertNull((Object)crowdUser);
        String currentConfluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertEquals((String)confluenceUser, (String)currentConfluenceUser);
    }

    public void testLoginToCrowdConsequentlyLoggedInToConfluence_unauthorisedFailure() {
        this.log("Running testLoginToCrowdConsequentlyLoggedInToConfluence_unauthorisedFailure");
        this.logoutFromCrowd();
        this.logoutFromConfluence();
        String crowdUser = this.loginToCrowd(CROWD_ONLY_USER_USERNAME, PASSWORD);
        ConfluenceSingleSignOnTest.assertNotNull((Object)crowdUser);
        String confluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertNull((Object)confluenceUser);
        String currentCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        ConfluenceSingleSignOnTest.assertEquals((String)crowdUser, (String)currentCrowdUser);
    }

    public void testSwitchUserInCrowdConsequentlySwitchesUserInConfluence_unauthorisedFailure() {
        this.log("Running testSwitchUserInCrowdConsequentlySwitchesUserInConfluence_unauthorisedFailure");
        String crowdUser = this.loginToCrowd("admin", "admin");
        ConfluenceSingleSignOnTest.assertNotNull((Object)crowdUser);
        String confluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertNotNull((Object)confluenceUser);
        this.logoutFromCrowd();
        String newCrowdUser = this.loginToCrowd(CROWD_ONLY_USER_USERNAME, PASSWORD);
        ConfluenceSingleSignOnTest.assertNotSame((Object)newCrowdUser, (Object)crowdUser);
        String newConfluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertNull((Object)newConfluenceUser);
    }

    public void testSwitchUserInConfluenceConsequentlySwitchesUserInCrowd_unauthorisedFailure() {
        this.log("Running testSwitchUserInConfluenceConsequentlySwitchesUserInCrowd_unauthorisedFailure");
        String crowdUser = this.loginToCrowd("admin", "admin");
        ConfluenceSingleSignOnTest.assertNotNull((Object)crowdUser);
        String confluenceUser = this.getCurrentlyLoggedInConfluenceUserFullName();
        ConfluenceSingleSignOnTest.assertNotNull((Object)confluenceUser);
        this.logoutFromConfluence();
        String newConfluenceUser = this.loginToConfluence(CONFLUENCE_ONLY_USER_USERNAME, "admin");
        ConfluenceSingleSignOnTest.assertNotSame((Object)newConfluenceUser, (Object)confluenceUser);
        String newCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        ConfluenceSingleSignOnTest.assertNull((Object)newCrowdUser);
    }
}

