/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.bamboo;

import com.atlassian.crowd.acceptance.tests.applications.bamboo.BambooAcceptanceTestCase;

public class BambooMixedCaseGroupTest
extends BambooAcceptanceTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.adminLoginToBamboo();
    }

    public void testBambooGroupCrud() {
        this._testAddBambooUserGroupMembership();
        this._testRemoveBambooUserGroupMembership();
        this._testDeleteBambooGroup();
    }

    private void _testAddBambooUserGroupMembership() {
        this.gotoBrowseGroups();
        this.clickLink("editGroup-bamboo-MixedCase-group");
        this.setWorkingForm("updateGroup");
        this.setTextField("membersInput", "bamboo-admin-user");
        this.submit();
        this.assertTextInTable("existingGroups", new String[]{"bamboo-MixedCase-group", "1", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-admin", "2", "Edit"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-users", "1", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"crowd-administrators", "1", "Edit | Delete"});
        this.verifyGroupExistsInCrowd("bamboo-MixedCase-group", "bamboo-admin-user");
    }

    private void _testRemoveBambooUserGroupMembership() {
        this.gotoBrowseGroups();
        this.clickLink("editGroup-bamboo-MixedCase-group");
        this.setWorkingForm("updateGroup");
        this.getDialog().unselectOptions("currentMembers", new String[]{"bamboo-admin-user"});
        this.submit();
        this.assertTextInTable("existingGroups", new String[]{"bamboo-MixedCase-group", "0", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-admin", "2", "Edit"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-users", "1", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"crowd-administrators", "1", "Edit | Delete"});
        this.verifyGroupExistsInCrowd("bamboo-MixedCase-group", new String[0]);
    }

    private void _testDeleteBambooGroup() {
        this.gotoBrowseGroups();
        this.clickLink("deleteGroup-bamboo-MixedCase-group");
        this.assertTextInTable("existingGroups", new String[]{"bamboo-admin", "2", "Edit"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-users", "1", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"crowd-administrators", "1", "Edit | Delete"});
        this.assertTextNotInTable("existingGroups", new String[]{"bamboo-MixedCase-group"});
        this.verifyGroupDoesNotExistInCrowd("bamboo-MixedCase-group");
    }
}

