/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.entity;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserComparator;
import com.atlassian.crowd.integration.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.integration.rest.entity.PasswordEntity;
import com.atlassian.crowd.model.user.UserWithAttributes;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ToStringBuilder;

@XmlRootElement(name="user")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UserEntity
implements UserWithAttributes {
    @XmlAttribute(name="name")
    private final String name;
    @XmlElement(name="first-name")
    private final String firstName;
    @XmlElement(name="last-name")
    private final String lastName;
    @XmlElement(name="display-name")
    private final String displayName;
    @XmlElement(name="email")
    private final String emailAddress;
    @XmlElement(name="password")
    private final PasswordEntity password;
    @XmlElement(name="encrypted-password")
    private final PasswordEntity encryptedPassword;
    @XmlElement(name="active")
    private final boolean active;
    @XmlElement(name="key")
    private final String key;
    @XmlElement(name="attributes")
    private MultiValuedAttributeEntityList attributes;

    private UserEntity() {
        this(null, null, null, null, null, null, false, null);
    }

    public UserEntity(String name, String firstName, String lastName, String displayName, String emailAddress, PasswordEntity password, boolean active, String key) {
        this(name, firstName, lastName, displayName, emailAddress, password, active, key, false);
    }

    public UserEntity(String name, String firstName, String lastName, String displayName, String emailAddress, PasswordEntity password, boolean active, String key, boolean isPasswordEncrypted) {
        this.name = name;
        this.firstName = firstName;
        this.lastName = lastName;
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        if (isPasswordEncrypted) {
            this.password = null;
            this.encryptedPassword = password;
        } else {
            this.password = password;
            this.encryptedPassword = null;
        }
        this.active = active;
        this.key = key;
    }

    public UserEntity(String name, String firstName, String lastName, String displayName, String emailAddress, PasswordEntity password, boolean active) {
        this(name, firstName, lastName, displayName, emailAddress, password, active, null);
    }

    public UserEntity(String name, String firstName, String lastName, String displayName, String emailAddress, PasswordEntity password, boolean active, boolean isPasswordEncrypted) {
        this(name, firstName, lastName, displayName, emailAddress, password, active, null, isPasswordEncrypted);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public PasswordEntity getPassword() {
        return this.password;
    }

    public PasswordEntity getEncryptedPassword() {
        return this.encryptedPassword;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setAttributes(MultiValuedAttributeEntityList attributes) {
        this.attributes = attributes;
    }

    public MultiValuedAttributeEntityList getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<String> getValues(String key) {
        return this.attributes.getValues(key);
    }

    @Override
    public String getValue(String key) {
        return this.attributes.getValue(key);
    }

    @Override
    public Set<String> getKeys() {
        return this.attributes.getKeys();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    @Deprecated
    public long getDirectoryId() {
        return 0L;
    }

    @Override
    public int compareTo(User user) {
        return UserComparator.compareTo(this, user);
    }

    @Override
    public String getExternalId() {
        return this.key;
    }

    @Override
    public boolean equals(Object o) {
        return UserComparator.equalsObject(this, o);
    }

    @Override
    public int hashCode() {
        return UserComparator.hashCode(this);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("active", this.isActive()).append("emailAddress", (Object)this.getEmailAddress()).append("firstName", (Object)this.getFirstName()).append("lastName", (Object)this.getLastName()).append("displayName", (Object)this.getDisplayName()).append("externalId", (Object)this.getExternalId()).toString();
    }

    public static UserEntity newMinimalInstance(String username) {
        return new UserEntity(username, null, null, null, null, null, false, null);
    }
}

