/*
 * Copyright © 2010 - 2014 Atlassian Corporation Pty Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.atlassian.crowd.integration.rest.entity;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(XmlAccessType.FIELD)
public abstract class AbstractAttributeEventEntity extends AbstractEventEntity
{

    @XmlElement(name = "storedAttributes")
    private MultiValuedAttributeEntityList storedAttributes;

    @XmlElement(name = "deletedAttributes")
    private MultiValuedAttributeEntityList deletedAttributes;

    /**
     * JAXB requires a no-arg constructor
     */
    protected AbstractAttributeEventEntity()
    {
        this.storedAttributes = null;
        this.deletedAttributes = null;
    }

    public MultiValuedAttributeEntityList getStoredAttributes()
    {
        return storedAttributes;
    }

    public MultiValuedAttributeEntityList getDeletedAttributes()
    {
        return deletedAttributes;
    }
}
