/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.auth.jwt;

import com.atlassian.connect.spring.AtlassianHost;
import com.atlassian.connect.spring.AtlassianHostRepository;
import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.auth.jwt.InvalidJwtException;
import com.atlassian.connect.spring.internal.auth.jwt.JwtAuthentication;
import com.atlassian.connect.spring.internal.auth.jwt.JwtAuthenticationToken;
import com.atlassian.connect.spring.internal.auth.jwt.JwtCredentials;
import com.atlassian.connect.spring.internal.auth.jwt.UnknownJwtIssuerException;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptorLoader;
import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import com.atlassian.connect.spring.internal.jwt.CanonicalRequestUtil;
import com.atlassian.connect.spring.internal.jwt.HttpRequestCanonicalizer;
import com.atlassian.connect.spring.internal.jwt.JwtExpiredException;
import com.atlassian.connect.spring.internal.jwt.JwtParseException;
import com.atlassian.connect.spring.internal.jwt.JwtParser;
import com.atlassian.connect.spring.internal.jwt.JwtReader;
import com.atlassian.connect.spring.internal.jwt.JwtVerificationException;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class JwtAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationProvider.class);
    private static final Class<JwtAuthenticationToken> TOKEN_CLASS = JwtAuthenticationToken.class;
    private AddonDescriptorLoader addonDescriptorLoader;
    private AtlassianHostRepository hostRepository;

    public JwtAuthenticationProvider(AddonDescriptorLoader addonDescriptorLoader, AtlassianHostRepository hostRepository) {
        this.addonDescriptorLoader = addonDescriptorLoader;
        this.hostRepository = hostRepository;
    }

    public boolean supports(Class<?> authenticationClass) {
        return authenticationClass.equals(TOKEN_CLASS);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        JwtCredentials jwtCredentials = this.getJwtCredentials(authentication);
        JWTClaimsSet unverifiedClaims = this.parseToken(jwtCredentials.getRawJwt());
        log.debug("Parsed JWT: {}", (Object)unverifiedClaims);
        String hostClientKey = this.getHostClientKeyFromSelfAuthenticationToken(unverifiedClaims).orElseGet(() -> ((JWTClaimsSet)unverifiedClaims).getIssuer());
        AtlassianHost host = this.getHost(hostClientKey);
        JWTClaimsSet verifiedClaims = this.verifyToken(jwtCredentials, host);
        String queryStringHash = this.computeQueryStringHash(jwtCredentials);
        try {
            AtlassianHostUser hostUser = this.createHostUserFromContextClaim(host, verifiedClaims).orElseGet(() -> this.createHostUserFromSubjectClaim(host, verifiedClaims));
            return new JwtAuthentication(hostUser, verifiedClaims, queryStringHash);
        }
        catch (ParseException e) {
            log.error("Context claim present, but not a JSON object. Unable to parse");
            throw new InvalidJwtException("Unable to parse context in JWT", e);
        }
    }

    private Optional<AtlassianHostUser> createHostUserFromContextClaim(AtlassianHost host, JWTClaimsSet verifiedClaims) throws ParseException {
        Map user;
        Map context = verifiedClaims.getJSONObjectClaim("context");
        if (context != null && (user = (Map)context.get("user")) != null) {
            JSONObject userJsonObject = new JSONObject(user);
            String accountId = userJsonObject.getAsString("accountId");
            String userKey = userJsonObject.getAsString("userKey");
            return Optional.of(AtlassianHostUser.builder((AtlassianHost)host).withUserAccountId(accountId).withUserKey(userKey).build());
        }
        return Optional.empty();
    }

    private AtlassianHostUser createHostUserFromSubjectClaim(AtlassianHost host, JWTClaimsSet verifiedClaims) {
        String userAccountId = verifiedClaims.getSubject();
        AtlassianHostUser.AtlassianHostUserBuilder builder = AtlassianHostUser.builder((AtlassianHost)host);
        Optional.ofNullable(userAccountId).ifPresent(arg_0 -> ((AtlassianHostUser.AtlassianHostUserBuilder)builder).withUserAccountId(arg_0));
        return builder.build();
    }

    private JwtCredentials getJwtCredentials(Authentication authentication) {
        JwtAuthenticationToken authenticationToken = TOKEN_CLASS.cast(authentication);
        return authenticationToken.getCredentials();
    }

    private JWTClaimsSet parseToken(String jwt) throws AuthenticationException {
        try {
            return new JwtParser().parse(jwt);
        }
        catch (JwtParseException e) {
            log.error(e.getMessage());
            throw new InvalidJwtException(e.getMessage(), e);
        }
    }

    private Optional<String> getHostClientKeyFromSelfAuthenticationToken(JWTClaimsSet unverifiedClaims) {
        Optional<String> optionalClientKey = Optional.empty();
        String addonKey = this.addonDescriptorLoader.getDescriptor().getKey();
        if (addonKey.equals(unverifiedClaims.getIssuer())) {
            this.assertValidSelfAuthenticationTokenAudience(unverifiedClaims, addonKey);
            Object clientKeyClaim = unverifiedClaims.getClaim("clientKey");
            String clientKey = this.assertValidSelfAuthenticationTokenClientKey(clientKeyClaim);
            optionalClientKey = Optional.of(clientKey);
        }
        return optionalClientKey;
    }

    private void assertValidSelfAuthenticationTokenAudience(JWTClaimsSet unverifiedClaims, String addonKey) {
        List audience = unverifiedClaims.getAudience();
        if (audience == null) {
            throw new BadCredentialsException("Missing audience for self-authentication token");
        }
        if (!audience.equals(Collections.singletonList(addonKey))) {
            throw new BadCredentialsException(String.format("Invalid audience (%s) for self-authentication token", String.join((CharSequence)",", audience)));
        }
    }

    private String assertValidSelfAuthenticationTokenClientKey(Object clientKeyClaim) {
        if (clientKeyClaim == null) {
            throw new BadCredentialsException("Missing client key claim for self-authentication token");
        }
        return clientKeyClaim.toString();
    }

    private AtlassianHost getHost(String clientKey) throws AuthenticationException {
        return (AtlassianHost)this.hostRepository.findById((Object)clientKey).orElseThrow(() -> {
            UnknownJwtIssuerException usernameNotFoundException = new UnknownJwtIssuerException(clientKey);
            log.debug(usernameNotFoundException.getMessage());
            return usernameNotFoundException;
        });
    }

    private JWTClaimsSet verifyToken(JwtCredentials jwtCredentials, AtlassianHost host) throws AuthenticationException {
        JWTClaimsSet claims;
        try {
            claims = new JwtReader(host.getSharedSecret()).readAndVerify(jwtCredentials.getRawJwt(), null);
        }
        catch (JwtParseException e) {
            log.error(e.getMessage());
            throw new InvalidJwtException(e.getMessage(), e);
        }
        catch (JwtExpiredException e) {
            log.error(e.getMessage());
            throw new CredentialsExpiredException(e.getMessage());
        }
        catch (JwtVerificationException e) {
            log.error(e.getMessage());
            throw new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
        log.debug("Verified JWT for host {} ({}) ", (Object)host.getBaseUrl(), (Object)host.getClientKey());
        return claims;
    }

    private String computeQueryStringHash(JwtCredentials jwtCredentials) {
        CanonicalHttpRequest canonicalHttpRequest = jwtCredentials.getCanonicalHttpRequest();
        log.debug("Canonical request for incoming JWT: {}", (Object)CanonicalRequestUtil.toVerboseString((CanonicalHttpRequest)canonicalHttpRequest));
        try {
            return HttpRequestCanonicalizer.computeCanonicalRequestHash((CanonicalHttpRequest)canonicalHttpRequest);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

