/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.oauth2;

import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.jwt.InvalidKeyException;
import com.atlassian.connect.spring.internal.jwt.JwtJsonBuilder;
import com.atlassian.connect.spring.internal.jwt.JwtWriter;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.MACSigner;
import java.net.URI;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OAuth2JwtAssertionGenerator {
    private static final Logger log = LoggerFactory.getLogger(OAuth2JwtAssertionGenerator.class);

    public String getAssertionString(AtlassianHostUser hostUser, URI authorizationServerUrl) {
        long iat = System.currentTimeMillis() / 1000L;
        Optional userKey = hostUser.getUserKey();
        Optional userAccountId = hostUser.getUserAccountId();
        if (!userAccountId.isPresent() && !userKey.isPresent()) {
            throw new IllegalArgumentException("Either the userKey (deprecated) or the userAccountId must be provided.");
        }
        JwtJsonBuilder jwtBuilder = new JwtJsonBuilder().issuedAt(iat).expirationTime(iat + 60L).issuer("urn:atlassian:connect:clientid:" + hostUser.getHost().getOauthClientId()).audience(authorizationServerUrl.toASCIIString()).claim("tnt", (Object)hostUser.getHost().getBaseUrl());
        if (userAccountId.isPresent()) {
            jwtBuilder.subject("urn:atlassian:connect:useraccountid:" + (String)userAccountId.get());
        } else {
            jwtBuilder.subject("urn:atlassian:connect:userkey:" + (String)userKey.get());
        }
        String json = jwtBuilder.build();
        log.debug("Created OAuth 2.0 JWT assertion: {}", (Object)json);
        return this.createJwtWriter(hostUser.getHost().getSharedSecret()).jsonToJwt(json);
    }

    private JwtWriter createJwtWriter(String secret) {
        try {
            return new JwtWriter(JWSAlgorithm.HS256, (JWSSigner)new MACSigner(secret));
        }
        catch (KeyLengthException e) {
            throw new InvalidKeyException((Throwable)e);
        }
    }
}

