/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.jwt;

import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import com.atlassian.connect.spring.internal.jwt.CanonicalRequestUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;

public class CanonicalHttpUriComponentsRequest
implements CanonicalHttpRequest {
    private final String httpMethod;
    private final String relativePath;
    private final Map<String, String[]> parameterMap;

    public CanonicalHttpUriComponentsRequest(HttpMethod httpMethod, UriComponents uriComponents, String contextPath) {
        this.httpMethod = httpMethod.name();
        this.relativePath = CanonicalRequestUtil.getRelativePath((String)uriComponents.getPath(), (String)contextPath);
        this.parameterMap = CanonicalHttpUriComponentsRequest.toArrayMap((MultiValueMap<String, String>)uriComponents.getQueryParams());
    }

    public String getMethod() {
        return this.httpMethod;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    private static Map<String, String[]> toArrayMap(MultiValueMap<String, String> queryParams) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (Map.Entry entry : queryParams.entrySet()) {
            List<String> values = ((List)entry.getValue()).stream().map(CanonicalHttpUriComponentsRequest::decode).collect(Collectors.toList());
            result.put(CanonicalHttpUriComponentsRequest.decode((String)entry.getKey()), values.toArray(new String[((List)entry.getValue()).size()]));
        }
        return result;
    }

    private static String decode(String value) {
        try {
            return URLDecoder.decode(value, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

