/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request;

import com.atlassian.connect.spring.AtlassianHost;
import com.atlassian.connect.spring.internal.request.AtlassianHostUriResolver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;

public abstract class AtlassianConnectHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final String USER_AGENT_PRODUCT = "atlassian-connect-spring-boot";
    private String atlassianConnectClientVersion;

    public AtlassianConnectHttpRequestInterceptor(String atlassianConnectClientVersion) {
        this.atlassianConnectClientVersion = atlassianConnectClientVersion;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpRequest interceptedRequest = this.getHostForRequest(request).map(host -> this.wrapRequest(request, (AtlassianHost)host)).orElse(request);
        return execution.execute(interceptedRequest, body);
    }

    protected abstract Optional<AtlassianHost> getHostForRequest(HttpRequest var1);

    protected void assertRequestToHost(HttpRequest request, AtlassianHost host) {
        URI requestUri = request.getURI();
        if (requestUri.isAbsolute() && !AtlassianHostUriResolver.isRequestToHost(requestUri, host)) {
            throw new IllegalArgumentException("Aborting the request to " + requestUri.toASCIIString() + " because this RestTemplate is associated with " + host.getBaseUrl());
        }
    }

    protected HttpRequest rewrapRequest(HttpRequest request, AtlassianHost host) {
        return request;
    }

    private HttpRequest wrapRequest(HttpRequest request, AtlassianHost host) {
        URI uri = this.wrapUri(request, host);
        AtlassianConnectHttpRequestWrapper requestWrapper = new AtlassianConnectHttpRequestWrapper(request, uri);
        return this.rewrapRequest((HttpRequest)requestWrapper, host);
    }

    private URI wrapUri(HttpRequest request, AtlassianHost host) {
        URI uri = request.getURI();
        if (!uri.isAbsolute()) {
            URI baseUri = URI.create(host.getBaseUrl());
            uri = baseUri.resolve(this.getUriToResolve(uri, baseUri));
        }
        return uri;
    }

    private URI getUriToResolve(URI uri, URI baseUri) {
        String path;
        String pathToResolve = "";
        String baseUriPath = baseUri.getPath();
        if (baseUriPath != null) {
            pathToResolve = pathToResolve + baseUriPath;
        }
        if ((path = uri.getPath()) != null) {
            String pathToAppend = pathToResolve.endsWith("/") && path.startsWith("/") ? path.substring(1) : path;
            pathToResolve = pathToResolve + pathToAppend;
        }
        try {
            uri = new URI(null, null, pathToResolve, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return uri;
    }

    private class AtlassianConnectHttpRequestWrapper
    extends HttpRequestWrapper {
        private final URI uri;

        public AtlassianConnectHttpRequestWrapper(HttpRequest request, URI uri) {
            super(request);
            this.uri = uri;
            super.getHeaders().set("User-Agent", String.format("%s/%s", AtlassianConnectHttpRequestInterceptor.USER_AGENT_PRODUCT, AtlassianConnectHttpRequestInterceptor.this.atlassianConnectClientVersion));
        }

        public URI getURI() {
            return this.uri;
        }
    }
}

