/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.lifecycle;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.concurrent.ListenableFuture;

@Service
public class TransactionExecutor {
    private static final Logger log = LoggerFactory.getLogger(TransactionExecutor.class);
    @Autowired
    private Optional<TransactionTemplate> optionalTransactionTemplate;

    @Async
    public <T> ListenableFuture<T> executeWithRollbackOption(Supplier<T> supplier, AtomicBoolean shouldRollback) {
        TransactionCallbackWithTimeout callback = new TransactionCallbackWithTimeout(supplier, shouldRollback);
        Object result = this.optionalTransactionTemplate.map(template -> template.execute(callback)).orElseGet(supplier);
        return AsyncResult.forValue((Object)result);
    }

    private static class TransactionCallbackWithTimeout<T>
    implements TransactionCallback<T> {
        private final Supplier<T> supplier;
        private final AtomicBoolean shouldRollback;

        public TransactionCallbackWithTimeout(Supplier<T> supplier, AtomicBoolean shouldRollback) {
            this.supplier = supplier;
            this.shouldRollback = shouldRollback;
        }

        public T doInTransaction(TransactionStatus status) {
            T result = this.supplier.get();
            if (this.shouldRollback.get()) {
                log.debug("Rolling back transaction.");
                status.setRollbackOnly();
            }
            return result;
        }
    }
}

