/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.auth;

import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.IgnoreJwt;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptorLoader;
import java.lang.annotation.Annotation;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class RequireAuthenticationHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(RequireAuthenticationHandlerInterceptor.class);
    @Autowired
    private AddonDescriptorLoader addonDescriptorLoader;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.isApplicableDispatcherType(request) && this.handlerRequiresJwtAuthentication(handler) && !this.requestIsSigned()) {
            log.info("Rejected incoming request for controller requiring JWT authentication ({} {})", (Object)request.getMethod(), (Object)request.getRequestURI());
            response.addHeader("WWW-Authenticate", String.format("JWT realm=\"%s\"", this.addonDescriptorLoader.getDescriptor().getKey()));
            response.sendError(HttpStatus.UNAUTHORIZED.value());
            return false;
        }
        return true;
    }

    private boolean handlerRequiresJwtAuthentication(Object handler) {
        return handler instanceof HandlerMethod && !this.handlerHasAnnotation((HandlerMethod)handler, IgnoreJwt.class);
    }

    private <T extends Annotation> boolean handlerHasAnnotation(HandlerMethod method, Class<T> annotationClass) {
        return method.getMethod().isAnnotationPresent(annotationClass) || method.getBeanType().isAnnotationPresent(annotationClass);
    }

    private boolean requestIsSigned() {
        boolean signed = false;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            signed = authentication.isAuthenticated() && authentication.getPrincipal() instanceof AtlassianHostUser;
        }
        return signed;
    }

    private boolean isApplicableDispatcherType(HttpServletRequest request) {
        DispatcherType dispatcherType = request.getDispatcherType();
        return !dispatcherType.equals((Object)DispatcherType.ASYNC) && !dispatcherType.equals((Object)DispatcherType.ERROR);
    }
}

