/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.auth;

import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;

@Configuration
@Order(value=0x7FFFFFFB)
public class AtlassianConnectWebSecurityConfigurer
extends WebSecurityConfigurerAdapter {
    private static final long ONE_YEAR_IN_SECONDS = TimeUnit.SECONDS.convert(365L, TimeUnit.DAYS);
    @Autowired
    private WebEndpointProperties webEndpointProperties;

    protected void configure(HttpSecurity http) throws Exception {
        http.headers().frameOptions().disable().httpStrictTransportSecurity().includeSubDomains(false).maxAgeInSeconds(ONE_YEAR_IN_SECONDS).and().referrerPolicy().policy(ReferrerPolicyHeaderWriter.ReferrerPolicy.ORIGIN_WHEN_CROSS_ORIGIN);
        http.csrf().disable();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        String managementPath = this.webEndpointProperties.getBasePath();
        if (managementPath != null) {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{managementPath + "/**"})).authenticated().and()).httpBasic();
        }
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }
}

