/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.oauth2;

import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.jwt.JwtJsonBuilder;
import com.atlassian.connect.spring.internal.jwt.JwtWriter;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import java.net.URI;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class OAuth2JwtAssertionGenerator {
    public String getAssertionString(AtlassianHostUser hostUser, URI authorizationServerUrl) {
        long iat = System.currentTimeMillis() / 1000L;
        JwtJsonBuilder jsonBuilder = new JwtJsonBuilder();
        Optional maybeUserKey = hostUser.getUserKey();
        if (!maybeUserKey.isPresent()) {
            throw new IllegalArgumentException("The key of a user to act as must be provided");
        }
        jsonBuilder.issuedAt(iat).expirationTime(iat + 60L).issuer("urn:atlassian:connect:clientid:" + hostUser.getHost().getOauthClientId()).subject("urn:atlassian:connect:userkey:" + (String)maybeUserKey.get()).audience(authorizationServerUrl.toASCIIString()).claim("tnt", (Object)hostUser.getHost().getBaseUrl());
        return this.createJwtWriter(hostUser.getHost().getSharedSecret()).jsonToJwt(jsonBuilder.build());
    }

    private JwtWriter createJwtWriter(String secret) {
        return new JwtWriter(JWSAlgorithm.HS256, (JWSSigner)new MACSigner(secret));
    }
}

