/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.oauth2;

import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.request.HostUriWrapper;
import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;

public class ActorHostUrlReconcilingInterceptor
implements ClientHttpRequestInterceptor {
    private final AtlassianHostUser hostUser;

    public ActorHostUrlReconcilingInterceptor(AtlassianHostUser hostUser) {
        this.hostUser = hostUser;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        URI requestUri = request.getURI();
        if (requestUri.isAbsolute()) {
            if (!HostUriWrapper.isRequestToAuthenticatedHost(request, this.hostUser)) {
                throw new UnsupportedOperationException("Aborting the request to " + requestUri.toASCIIString() + requestUri.getPath() + " because the user you're trying to make a request does not reside on this host. The base url of the user's instance is " + this.hostUser.getHost().getBaseUrl());
            }
            return execution.execute(request, body);
        }
        final URI absoluteRequestUri = HostUriWrapper.wrapUri(request, this.hostUser);
        HttpRequestWrapper absoluteRequest = new HttpRequestWrapper(request){

            public URI getURI() {
                return absoluteRequestUri;
            }
        };
        return execution.execute((HttpRequest)absoluteRequest, body);
    }
}

