/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.jwt;

import com.atlassian.connect.spring.internal.jwt.JwtJsonBuilder;
import com.atlassian.connect.spring.internal.jwt.JwtWriter;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import java.time.Duration;

public class JwtBuilder {
    private JwtJsonBuilder jwtJsonBuilder;
    private String sharedSecret;

    public JwtBuilder() {
        this.jwtJsonBuilder = new JwtJsonBuilder();
    }

    public JwtBuilder(Duration expireAfter) {
        this.jwtJsonBuilder = new JwtJsonBuilder(expireAfter);
    }

    public JwtBuilder issuer(String iss) {
        this.jwtJsonBuilder.issuer(iss);
        return this;
    }

    public JwtBuilder subject(String sub) {
        this.jwtJsonBuilder.subject(sub);
        return this;
    }

    public JwtBuilder audience(String aud) {
        this.jwtJsonBuilder.audience(aud);
        return this;
    }

    public JwtBuilder expirationTime(long exp) {
        this.jwtJsonBuilder.expirationTime(exp);
        return this;
    }

    public JwtBuilder notBefore(long nbf) {
        this.jwtJsonBuilder.notBefore(nbf);
        return this;
    }

    public JwtBuilder issuedAt(long iat) {
        this.jwtJsonBuilder.issuedAt(iat);
        return this;
    }

    public JwtBuilder queryHash(String queryHash) {
        this.jwtJsonBuilder.queryHash(queryHash);
        return this;
    }

    public JwtBuilder claim(String name, Object value) {
        this.jwtJsonBuilder.claim(name, value);
        return this;
    }

    public JwtBuilder signature(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        return this;
    }

    public String build() {
        String jwtPayload = this.jwtJsonBuilder.build();
        return this.createJwtWriter().jsonToJwt(jwtPayload);
    }

    private JwtWriter createJwtWriter() {
        return new JwtWriter(JWSAlgorithm.HS256, (JWSSigner)new MACSigner(this.sharedSecret));
    }

    public String toString() {
        return this.build();
    }
}

