/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request;

import com.atlassian.connect.spring.AtlassianHostUser;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.http.HttpRequest;

public class HostUriWrapper {
    public static URI wrapUri(HttpRequest request, AtlassianHostUser hostUser) {
        URI uri = request.getURI();
        if (!uri.isAbsolute()) {
            URI baseUri = URI.create(hostUser.getHost().getBaseUrl());
            uri = baseUri.resolve(HostUriWrapper.getUriToResolve(baseUri, uri));
        }
        return uri;
    }

    private static URI getUriToResolve(URI baseUri, URI uri) {
        String path;
        String pathToResolve = "";
        String baseUriPath = baseUri.getPath();
        if (baseUriPath != null) {
            pathToResolve = pathToResolve + baseUriPath;
        }
        if ((path = uri.getPath()) != null) {
            String pathToAppend = pathToResolve.endsWith("/") && path.startsWith("/") ? path.substring(1) : path;
            pathToResolve = pathToResolve + pathToAppend;
        }
        try {
            uri = new URI(null, null, pathToResolve, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return uri;
    }

    public static boolean isRequestToAuthenticatedHost(HttpRequest request, AtlassianHostUser hostUser) {
        URI requestUri;
        URI hostBaseUri = URI.create(hostUser.getHost().getBaseUrl());
        return !hostBaseUri.relativize(requestUri = request.getURI()).isAbsolute();
    }
}

