define('confluence-watch-button/watch-model', [
    'ajs',
    'backbone'
], function (
    AJS,
    Backbone
) {
    return Backbone.Model.extend({

        saveSettings: function(url, data) {
            this.trigger("request");
            var self = this;
            return AJS.safe.ajax({
                url: url,
                type: "POST",
                dataType: "json",
                data: data
            }).done(function() {
                self.trigger("sync", self);
            }).fail(function() {
                self.trigger("error")
            });
        },

        saveWatchPage: function(watching) {
            var url = AJS.contextPath() + "/users/" + (watching ? "add" : "remove") + "pagenotificationajax.action";
            this.set("watchingPage", watching);
            return this.saveSettings(url, {pageId: this.get("pageId")});
        },

        saveWatchBlogs: function(watching) {
            var url = AJS.contextPath() + "/users/" + (watching ? "add" : "remove") + "spacenotificationajax.action";
            this.set("watchingBlogs", watching);
            return this.saveSettings(url, {
                spaceKey: this.get("spaceKey"),
                contentType: "blogpost"
            });
        },

        saveWatchSpace: function(watching) {
            var url = AJS.contextPath() + "/users/" + (watching ? "add" : "remove") + "spacenotificationajax.action";
            this.set("watchingSpace", watching);
            return this.saveSettings(url, {spaceKey: this.get("spaceKey")});
        }
    });
});