/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.templates.config;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.plugin.templates.TemplatePackageManager;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureTemplatesAction
extends ConfluenceActionSupport {
    private TemplatePackageManager templatePackageManager;
    private String spaceKey;
    private String[] toInstall;
    private List<String> installed;
    private String status;

    public String input() {
        return "input";
    }

    public String install() {
        if (ArrayUtils.isEmpty(this.toInstall)) {
            this.status = "noinput";
            return "input";
        }
        Space destination = null;
        if (!StringUtils.isEmpty(this.spaceKey)) {
            destination = this.templatePackageManager.getSpaceManager().getSpace(this.spaceKey);
        }
        this.installed = new ArrayList<String>();
        Map<String, PageTemplate> byHash = this.templatePackageManager.getTemplatesByHash();
        for (String templateHashCode : this.toInstall) {
            if (!byHash.containsKey(templateHashCode)) continue;
            PageTemplate template = byHash.get(templateHashCode);
            template.setSpace(destination);
            this.templatePackageManager.getTemplateManager().savePageTemplate(template, null);
            this.installed.add(template.getName());
        }
        this.status = "success";
        return "success";
    }

    public String getStatus() {
        return this.status;
    }

    public List<String> getInstalled() {
        return this.installed;
    }

    public String getActionName(String className) {
        return "Configure Template Packages Plugin";
    }

    public String getAdminUrl() {
        StringBuilder adminUrl = new StringBuilder("pages/templates2/listpagetemplates.action");
        if (!StringUtils.isEmpty(this.spaceKey)) {
            adminUrl.append("?key=").append(this.spaceKey);
        }
        return adminUrl.toString();
    }

    public String getSpaceName() {
        if (StringUtils.isEmpty(this.spaceKey)) {
            return this.getText("template.config.global.space");
        }
        return this.templatePackageManager.getSpaceManager().getSpace(this.spaceKey).getName();
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setToInstall(String[] toInstall) {
        this.toInstall = toInstall;
    }

    public void setTemplatePackage(TemplatePackageManager templatePackageManager) {
        this.templatePackageManager = templatePackageManager;
    }

    public List<Space> getSpaces() {
        return this.templatePackageManager.getSpaceManager().getAllSpaces();
    }

    public List<PageTemplate> getInstalledTemplates() {
        return this.templatePackageManager.getInstalledTemplates();
    }

    public Set<String> getInstalledTemplatesNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (PageTemplate t : this.getInstalledTemplates()) {
            names.add(t.getName());
        }
        return names;
    }

    public Set<String> getConflictNames() {
        TreeSet<String> names = new TreeSet<String>();
        TreeSet<String> conflictSet = new TreeSet<String>();
        for (Map.Entry<String, List<PageTemplate>> entry : this.templatePackageManager.getAvailableTemplates().entrySet()) {
            for (PageTemplate t : entry.getValue()) {
                if (names.contains(t.getName())) {
                    conflictSet.add(t.getName());
                }
                names.add(t.getName());
            }
        }
        return conflictSet;
    }

    public Map<String, List<PageTemplate>> getAvailableTemplates() {
        Map<String, List<Object>> templates = this.templatePackageManager.getAvailableTemplates();
        if (null == templates) {
            templates = Collections.emptyMap();
        }
        return templates;
    }
}

