/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.status;

import java.awt.Color;

public enum StatusColour {
    GREY(Color.decode("#253858"), Color.decode("#42526e")),
    GREEN(Color.WHITE, Color.decode("#00875A"), "aui-lozenge-success"),
    RED(Color.WHITE, Color.decode("#DE350B"), "aui-lozenge-error"),
    YELLOW(Color.decode("#253858"), Color.decode("#42526e"), "aui-lozenge-moved"),
    BLUE(Color.decode("#0052cc"), Color.decode("#0052CC"), "aui-lozenge-current");

    public static StatusColour DEFAULT;
    private final String cssClassName;
    private final Color defaultTextColor;
    private final Color subtleTextColor;

    private StatusColour(Color defaultTextColor, Color subtleTextColor) {
        this(defaultTextColor, subtleTextColor, null);
    }

    private StatusColour(Color defaultTextColor, Color subtleTextColor, String cssClassName) {
        this.defaultTextColor = defaultTextColor;
        this.subtleTextColor = subtleTextColor;
        this.cssClassName = cssClassName;
    }

    public Color forText(boolean subtle) {
        return subtle ? this.subtleTextColor : this.defaultTextColor;
    }

    public String correspondingLozengeCssClass() {
        return this.cssClassName;
    }

    public static StatusColour fromString(String name) {
        try {
            return StatusColour.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return DEFAULT;
        }
    }

    static {
        DEFAULT = GREY;
    }
}

