define('confluence/share-page/popup/setup-restriction-warning', [
    'jquery'
], function ($) {
    /**
     * Sets up the Restriction Warning and button to open restriction dialog
     * @param $container
     * @param parameters        The dialog's parameters passed-through
     */
    return function setupRestrictionWarning($container, parameters) {
        if (typeof parameters.restriction === 'function') {
            $.when(parameters.restriction()).then(function (restrictionWarning) {
                if(restrictionWarning.type) {
                    var $row = $container.find('.restriction-warning-container');
                    $row.append(Confluence.Templates.Share.Dialog.restrictionWarning(restrictionWarning));
                    var $changeButton = $row.find('#restriction-open-button');
                    if ($changeButton.length) {
                        $changeButton.click(function (e) {
                            var $openRestrictionButton = $("#rte-button-restrictions");
                            if ($openRestrictionButton.length) {
                                $openRestrictionButton.trigger("click");
                            }
                            e.preventDefault();
                        });
                    }
                }
            });
        }
    }
});