define('confluence/share-page/autocomplete/autocomplete-user', [
    'ajs',
    'jquery',
    'confluence/legacy'
], function (AJS, $, Confluence) {
    return function autocompleteUser(scope) {
        scope = scope || document.body;
        var emailExpression = /^([a-zA-Z0-9_\.\-\+\!#\$%&'\*/=\?\^_`{|}~])+\@.*/;

        function makeRestMatrixFromData(restObj) {
            if (!restObj || !restObj.result) {
                throw new Error("Invalid JSON format");
            }
            var matrix = [];
            for (var i = 0; i < restObj.result.length; i++) {
                var data = restObj.result[i];
                if (data.type == "group") {
                    data = makeGroupObjectFromData(data);
                }
            }

            matrix.push(restObj.result);
            return matrix;
        }

        function makeGroupObjectFromData(data) {
            if (data.name == "confluence-users" ||
                data.name == "confluence-administrators") {
                return data;
            }
            data.title = data.name;
            data.group = data.name;
            data.thumbnailLink = {
                "href": Confluence.getContextPath() + "/download/resources/com.atlassian.confluence.plugins.share-page:_private_share-page-resources/images/group.png",
                "type": "image/png",
                "rel": "thumbnail"
            };
            data.link = [{
                "href": Confluence.getContextPath(),
                "rel": "self"
            }];
            return data;
        }

        $("input.autocomplete-sharepage[data-autocomplete-user-bound!=true]", scope).each(function () {
            var $this = $(this)
                .attr("data-autocomplete-sharepage-bound", "true")
                .attr("autocomplete", "off");
            var maxResults = $this.attr("data-max") || 10,
                alignment = $this.attr("data-alignment") || "left",
                dropDownTarget = $this.attr("data-dropdown-target"),
                dropDownPosition = null;

            if (dropDownTarget) {
                dropDownPosition = $(dropDownTarget);
            }
            else {
                dropDownPosition = $("<div></div>");
                $this.after(dropDownPosition);
            }
            dropDownPosition.addClass("aui-dd-parent autocomplete");

            $this.quicksearch(AJS.REST.getBaseUrl() + "search/user-or-group.json",
                function () {
                    $this.trigger("open.autocomplete-sharepage");
                }, {
                    makeParams: function (val) {
                        return {
                            "max-results": maxResults,
                            query: val.replace("{|}", "") // remove curly braces as jersey doesn't like them
                        };
                    },
                    dropdownPlacement: function (dd) {
                        dropDownPosition.append(dd);
                    },
                    makeRestMatrixFromData: makeRestMatrixFromData,
                    addDropdownData: function (matrix) {
                        var trimmedEmail = $.trim($this.val());
                        if (emailExpression.test(trimmedEmail)) {

                            matrix.push([{
                                name: trimmedEmail,
                                email: trimmedEmail,
                                href: "#",
                                icon: Confluence.getContextPath() + "/download/resources/com.atlassian.confluence.plugins.share-page:_private_share-page-resources/images/envelope.png"
                            }]);
                        }

                        if (!matrix.length) {
                            var noResults = $this.attr("data-none-message");
                            if (noResults) {
                                matrix.push([{
                                    name: noResults,
                                    className: "no-results",
                                    href: "#"
                                }]);
                            }
                        }

                        return matrix;
                    },
                    ajsDropDownOptions: {
                        alignment: alignment,
                        displayHandler: function (obj) {
                            if (obj.restObj && obj.restObj.username) {
                                return obj.name + " (" + obj.restObj.username + ")";
                            }
                            return obj.name;
                        },
                        selectionHandler: function (e, selection) {

                            if (selection.find(".search-for").length) {
                                $this.trigger("selected.autocomplete-sharepage", {searchFor: $this.val()});
                                return;
                            }
                            if (selection.find(".no-results").length) {
                                this.hide();
                                e.preventDefault();
                                return;
                            }

                            var contentProps = $("span:eq(0)", selection).data("properties");

                            if (!contentProps.email) {
                                contentProps = contentProps.restObj;
                            }

                            $this.trigger("selected.autocomplete-sharepage", {content: contentProps});
                            this.hide();
                            e.preventDefault();
                        }
                    }
                });
        });
    }
});