define('confluence/share-page/util/find-recipients', [
    'jquery'
], function ($) {
    return {
        /**
         * @param $contents of the popup
         * @returns {Array} A list of currently selected recipients.
         * @private
         */
        findAllRecipients: function countSelectedRecipients($contents) {
            return $contents.find(".recipients li");
        },
        /**
         * @param $contents of the popup
         * @returns {Array} A list of currently selected users.
         * @private
         */
        findUsers: function countUsers($contents) {
            var users = [];
            $contents.find(".recipients li[data-userKey]").each(function (index, item) {
                users.push($(item).attr("data-userKey"))
            });
            return users;
        },
        /**
         * @param $contents of the popup
         * @returns {Array} A list of currently selected email addresses
         * @private
         */
        findEmails: function countEmails($contents) {
            var emails = [];
            $contents.find(".recipients li[data-email]").each(function (index, item) {
                emails.push($(item).attr("data-email"))
            });
            return emails;
        },
        /**
         * @param $contents of the popup
         * @returns {Array} A list of currently selected groups
         * @private
         */
        findGroups: function countGroups($contents) {
            var groups = [];
            $contents.find(".recipients li[data-group]").each(function (index, item) {
                groups.push($(item).attr("data-group"))
            });
            return groups;
        }
    }
});