/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search;

import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.plugins.search.api.Searcher;
import com.atlassian.confluence.plugins.search.api.model.SearchExplanation;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.confluence.plugins.search.api.model.SearchResult;
import com.atlassian.confluence.plugins.search.api.model.SearchResults;
import com.atlassian.confluence.plugins.search.model.SearchResultBuilder;
import com.atlassian.confluence.plugins.search.model.SearchResultBuilderFactory;
import com.atlassian.confluence.plugins.search.query.ApplyPrefixToLabelFunction;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.BooleanQueryBuilder;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.DefaultHighlightParams;
import com.atlassian.confluence.search.v2.HightlightParams;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.Range;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.AllQuery;
import com.atlassian.confluence.search.v2.query.BoostingQuery;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.confluence.search.v2.query.MatchNoDocsQuery;
import com.atlassian.confluence.search.v2.query.SiteTextSearchQuery;
import com.atlassian.confluence.search.v2.searchfilter.ArchivedSpacesSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.BooleanSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ContentStatusFilter;
import com.atlassian.confluence.search.v2.searchfilter.CustomContentTypeSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.DeactivatedUserSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ExcludedContentTypeSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ExternallyDeletedUserSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.InSpaceSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.MatchNoDocsFilter;
import com.atlassian.confluence.search.v2.searchfilter.SiteSearchPermissionsSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.SpaceCategorySearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.TermRangeSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.TermSearchFilter;
import com.atlassian.confluence.search.v2.sort.RelevanceSort;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="searcherv3")
@ExportAsService(value={Searcher.class})
public class DefaultSearcher
implements Searcher {
    private final SearchManager searchManager;
    private final SpaceManager spaceManager;
    private final LabelManager labelManager;
    private final UserAccessor userAccessor;
    private final SearchResultBuilderFactory resultBuilderFactory;
    private final ContentEntityManager contentEntityManager;

    @Autowired
    public DefaultSearcher(@ComponentImport UserAccessor userAccessor, @ComponentImport LabelManager labelManager, @ComponentImport SpaceManager spaceManager, @ComponentImport SearchManager searchManager, @ComponentImport ContentEntityManager contentEntityManager, SearchResultBuilderFactory resultBuilderFactory) {
        this.userAccessor = userAccessor;
        this.labelManager = labelManager;
        this.spaceManager = spaceManager;
        this.searchManager = searchManager;
        this.contentEntityManager = contentEntityManager;
        this.resultBuilderFactory = resultBuilderFactory;
    }

    @Override
    public SearchResults search(SearchQueryParameters params, final boolean explain) {
        com.atlassian.confluence.search.v2.SearchResults results;
        SearchQuery query = this.getQuery(params);
        SearchFilter filter = this.getFilter(params);
        final Optional highlightParams = params.isHighlight() ? Optional.of(new DefaultHighlightParams((SearchQuery)MatchNoDocsQuery.getInstance())) : Optional.empty();
        ContentSearch search = new ContentSearch(query, (SearchSort)new RelevanceSort(), filter, params.getStartIndex(), params.getPageSize()){

            public String getSearchType() {
                return "SiteSearch";
            }

            public Optional<HightlightParams> getHighlight() {
                return highlightParams;
            }

            public boolean isExplain() {
                return explain;
            }
        };
        long start = System.currentTimeMillis();
        try {
            results = this.searchManager.search((ISearch)search);
        }
        catch (InvalidSearchException e) {
            throw new RuntimeException(e);
        }
        List<SearchResult> elements = StreamSupport.stream(results.spliterator(), false).map(result -> {
            SearchResultBuilder builder = this.resultBuilderFactory.createBuilder(result.getType(), (User)AuthenticatedUserThreadLocal.get());
            long id = SearchResultBuilder.getId(result.getField("handle"));
            ContentEntityObject contentEntity = this.contentEntityManager.getById(id);
            return builder.newSearchResult(arg_0 -> ((com.atlassian.confluence.search.v2.SearchResult)result).getField(arg_0), () -> ((com.atlassian.confluence.search.v2.SearchResult)result).getDisplayTitleWithHighlights(), () -> ((com.atlassian.confluence.search.v2.SearchResult)result).getResultExcerptWithHighlights(), () -> new SearchExplanation(result.getExplain().orElse(null), contentEntity));
        }).collect(Collectors.toList());
        long end = System.currentTimeMillis();
        if (results.getUnfilteredResultsCount() == 0 && !params.isIncludeArchivedSpaces()) {
            int numberOfResultsInArchivedSpace = this.findNumberOfResultsInArchivedSpace(params);
            return new SearchResults(0, numberOfResultsInArchivedSpace, elements, end - start, results.getSearchQuery());
        }
        return new SearchResults(results.getUnfilteredResultsCount(), 0, elements, end - start, results.getSearchQuery());
    }

    @Override
    public List<SearchExplanation> explain(SearchQueryParameters params, long[] contentIds) {
        SearchQuery query = this.getQuery(params);
        SearchFilter filter = this.getFilter(params);
        ContentSearch search = new ContentSearch(query, null, filter, params.getStartIndex(), params.getPageSize()){

            public String getSearchType() {
                return "SiteSearch";
            }
        };
        ArrayList<SearchExplanation> result = new ArrayList<SearchExplanation>();
        for (long id : contentIds) {
            String explanation = this.searchManager.explain((ISearch)search, id);
            result.add(new SearchExplanation(explanation, this.contentEntityManager.getById(id)));
        }
        return result;
    }

    private int findNumberOfResultsInArchivedSpace(SearchQueryParameters params) {
        SearchQueryParameters searchWithArchivedSpaces = SearchQueryParameters.newSearchQueryParameters(params).includeArchivedSpaces(true).build();
        SearchResults extendedSearchResults = this.search(searchWithArchivedSpaces, false);
        return extendedSearchResults.getTotalSize();
    }

    private SearchFilter getFilter(SearchQueryParameters params) {
        DateRangeQuery.DateRange lastModified;
        Date fromDate;
        BooleanQueryBuilder builder = BooleanSearchFilter.builder().addMust((Object)SiteSearchPermissionsSearchFilter.getInstance()).addMust((Object)this.getIgnoredTypeFilter()).addMust((Object[])this.getIgnoredUsersFilter());
        if (!params.isIncludeArchivedSpaces() && StringUtils.isBlank((CharSequence)params.getSpaceKey())) {
            builder.addMust((Object)new ArchivedSpacesSearchFilter(false, this.spaceManager));
        }
        if (params.getSpaceCategory() != null && params.getSpaceCategory() != SpaceCategoryEnum.ALL) {
            builder.addMust((Object)new SpaceCategorySearchFilter(Collections.singleton(params.getSpaceCategory()), this.labelManager));
        }
        if (StringUtils.isNotBlank((CharSequence)params.getSpaceKey())) {
            builder.addMust((Object)new InSpaceSearchFilter(Collections.singleton(params.getSpaceKey())));
        }
        if (params.getContentType() != null) {
            builder.addMust((Object)new TermSearchFilter("type", params.getContentType().getRepresentation()));
        }
        Iterable labels = Iterables.transform(params.getLabels(), (Function)ApplyPrefixToLabelFunction.getInstance());
        for (Option item : labels) {
            item.foreach(label -> builder.addShould((Object)new TermSearchFilter("label", StringUtils.trim((String)label))));
        }
        if (params.getPluginContentType() != null) {
            builder.addMust((Object)new CustomContentTypeSearchFilter(Collections.singleton(params.getPluginContentType().getIdentifier())));
        }
        if (params.getLastModified() != null && (fromDate = (lastModified = params.getLastModified().dateRange()).getFrom()) != null) {
            builder.addMust((Object)new TermRangeSearchFilter("modified", new Range((Object)LuceneUtils.dateToString((Date)fromDate), null, lastModified.isIncludeFrom(), false)));
        }
        if (params.getContributor() != null) {
            builder.addMust((Object)this.getContributorFilter(params));
        }
        builder.addMust((Object)ExcludedContentTypeSearchFilter.getInstance());
        builder.addMust((Object)ContentStatusFilter.getDefaultStatusInstance());
        return (SearchFilter)builder.build();
    }

    private SearchQuery getQuery(SearchQueryParameters params) {
        if (Strings.isNullOrEmpty((String)params.getQuery())) {
            return AllQuery.getInstance();
        }
        return new BoostingQuery((SearchQuery)new SiteTextSearchQuery(params.getQuery()), null);
    }

    private SearchFilter getIgnoredTypeFilter() {
        return (SearchFilter)BooleanSearchFilter.builder().addMustNot((Object)new TermSearchFilter("type", "space")).addMustNot((Object)new TermSearchFilter("type", "globaldescription")).build();
    }

    private SearchFilter[] getIgnoredUsersFilter() {
        return new SearchFilter[]{ExternallyDeletedUserSearchFilter.getInstance(), DeactivatedUserSearchFilter.getInstance()};
    }

    private SearchFilter getContributorFilter(SearchQueryParameters params) {
        ConfluenceUser user = this.userAccessor.getUserByName(params.getContributor());
        if (user != null) {
            return (SearchFilter)BooleanSearchFilter.builder().addShould((Object)new TermSearchFilter("creatorName", user.getKey().getStringValue())).addShould((Object)new TermSearchFilter("lastModifiers", user.getKey().getStringValue())).build();
        }
        return MatchNoDocsFilter.getInstance();
    }
}

