/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.query;

import com.atlassian.bonnie.analyzer.LuceneAnalyzerFactory;
import com.atlassian.confluence.plugins.search.boosting.BoostingQuery;
import com.atlassian.confluence.plugins.search.event.SiteSearchContainsSearchSyntaxEvent;
import com.atlassian.confluence.plugins.search.query.LuceneQueryUtil;
import com.atlassian.confluence.plugins.search.query.LuceneSpanQueryBuilder;
import com.atlassian.confluence.plugins.search.query.QueryFactory;
import com.atlassian.confluence.plugins.search.query.v2search.SiteTextSearchQuery;
import com.atlassian.confluence.search.lucene.LuceneQueryParserFactory;
import com.atlassian.confluence.search.v2.lucene.boosting.BoostingStrategy;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="queryFactory")
public class LuceneQueryFactory
implements QueryFactory {
    private static final Logger log = LoggerFactory.getLogger(LuceneQueryFactory.class);
    public static final float TITLE_FIELD_BOOST = 2.0f;
    public static final float SPAN_QUERY_BOOST = 4.0f;
    private final LuceneQueryParserFactory luceneQueryParserFactory;
    private final LuceneAnalyzerFactory luceneAnalyzerFactory;
    private final BoostingStrategy boostStrategy;
    private final LuceneSpanQueryBuilder spanQueryBuilder;
    private final EventPublisher eventPublisher;

    @Autowired
    public LuceneQueryFactory(@ComponentImport LuceneAnalyzerFactory luceneAnalyzerFactory, @ComponentImport LuceneQueryParserFactory luceneQueryParserFactory, BoostingStrategy pluggableBoostingStrategy, LuceneSpanQueryBuilder spanQueryBuilder, @ComponentImport EventPublisher eventPublisher) {
        this.luceneAnalyzerFactory = luceneAnalyzerFactory;
        this.luceneQueryParserFactory = luceneQueryParserFactory;
        this.boostStrategy = pluggableBoostingStrategy;
        this.spanQueryBuilder = spanQueryBuilder;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public Query getQuery(String queryString) {
        return this.getQuery(queryString, QueryFactory.Boost.BOOST);
    }

    @Override
    public Query getQuery(String queryString, QueryFactory.Boost doBoost) {
        if (Strings.isNullOrEmpty((String)queryString) || "*".equals(StringUtils.trim((String)queryString))) {
            MatchAllDocsQuery query = new MatchAllDocsQuery();
            query.setBoost(1.0f);
            return this.optionallyWrapWithBoostingQuery((Query)query, doBoost);
        }
        BooleanQuery query = new BooleanQuery(true);
        Analyzer analyzer = this.luceneAnalyzerFactory.createAnalyzer();
        if (!SiteTextSearchQuery.isQueryStringSyntax(queryString)) {
            PhraseQuery bodyPhraseQuery;
            PhraseQuery titlePhraseQuery;
            Optional<Query> titleSpanQuery = this.spanQueryBuilder.getQuery("title", queryString, analyzer);
            if (titleSpanQuery.isPresent()) {
                ((Query)titleSpanQuery.get()).setBoost(2.0f);
                BooleanQuery spanQueries = new BooleanQuery(true);
                spanQueries.add((Query)titleSpanQuery.get(), BooleanClause.Occur.SHOULD);
                spanQueries.add((Query)this.spanQueryBuilder.getQuery("contentBody", queryString, analyzer).get(), BooleanClause.Occur.SHOULD);
                spanQueries.setBoost(4.0f);
                query.add((Query)spanQueries, BooleanClause.Occur.SHOULD);
            }
            if ((titlePhraseQuery = this.createPhraseQuery("title", queryString, analyzer, true)) != null) {
                titlePhraseQuery.setBoost(2.0f);
                query.add((Query)titlePhraseQuery, BooleanClause.Occur.SHOULD);
            }
            if ((bodyPhraseQuery = this.createPhraseQuery("contentBody", queryString, analyzer, true)) != null) {
                query.add((Query)bodyPhraseQuery, BooleanClause.Occur.SHOULD);
            }
        } else {
            this.eventPublisher.publish((Object)new SiteSearchContainsSearchSyntaxEvent());
        }
        Query parsedQuery = this.getMultiFieldQuery(queryString);
        if (parsedQuery != null) {
            query.add(parsedQuery, BooleanClause.Occur.SHOULD);
        }
        return this.optionallyWrapWithBoostingQuery((Query)query, doBoost);
    }

    private Query optionallyWrapWithBoostingQuery(Query query, QueryFactory.Boost boost) {
        switch (boost) {
            case NO_BOOST: {
                return query;
            }
            case BOOST: {
                return new BoostingQuery(query, null, this.boostStrategy);
            }
        }
        throw new IllegalArgumentException("Unknown boost enum : " + (Object)((Object)boost));
    }

    private Query getMultiFieldQuery(String queryString) {
        StandardQueryParser queryParser = this.luceneQueryParserFactory.createQueryParser();
        queryParser.setMultiFields((CharSequence[])new String[]{"title", "contentBody"});
        queryParser.setFieldsBoost((Map)ImmutableMap.of((Object)"title", (Object)Float.valueOf(2.0f)));
        Query parsedQuery = null;
        try {
            parsedQuery = queryParser.parse(queryString, null);
        }
        catch (QueryNodeException e) {
            log.debug("Error parsing query: ", (Throwable)e);
        }
        return parsedQuery;
    }

    private PhraseQuery createPhraseQuery(String field, String queryString, Analyzer analyzer, boolean exact) {
        PhraseQuery phraseQuery = new PhraseQuery();
        Set<String> tokens = LuceneQueryUtil.tokenize(analyzer, field, queryString);
        if (tokens.size() == 1) {
            return null;
        }
        for (String token : tokens) {
            phraseQuery.add(new Term(field, token));
        }
        if (!exact) {
            phraseQuery.setSlop(tokens.size() + 1);
        }
        return phraseQuery;
    }
}

