/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.query;

import com.atlassian.confluence.content.ContentTypeModuleDescriptor;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.lucene.queries.ChainedFilter;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.FieldValueFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BytesRef;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="disabledContentTypeFilterFactory")
public class DisabledContentTypeFilterFactory {
    private final PluginAccessor pluginAccessor;
    private final Filter acceptAllCustomContentTypeDocs;

    @Autowired
    public DisabledContentTypeFilterFactory(@ComponentImport PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.acceptAllCustomContentTypeDocs = new CachingWrapperFilter((Filter)new FieldValueFilter("contentPluginKey"));
    }

    public Option<Filter> newFilter() {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(this.acceptAllCustomContentTypeDocs);
        LinkedList<BytesRef> contentTypeModuleKeys = new LinkedList<BytesRef>();
        for (ContentTypeModuleDescriptor contentTypeModuleDescriptor : this.pluginAccessor.getEnabledModuleDescriptorsByClass(ContentTypeModuleDescriptor.class)) {
            contentTypeModuleKeys.add(new BytesRef((CharSequence)contentTypeModuleDescriptor.getContentType()));
        }
        if (contentTypeModuleKeys.isEmpty()) {
            return Option.none();
        }
        filters.add(new TermsFilter("contentPluginKey", contentTypeModuleKeys));
        ChainedFilter acceptDisabledCustomContentTypeDocs = new ChainedFilter(filters.toArray(new Filter[2]), 3);
        return Option.some((Object)new ChainedFilter(new Filter[]{acceptDisabledCustomContentTypeDocs}, 2));
    }
}

