/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.boosting;

import com.atlassian.confluence.plugins.search.api.boosting.ExplainableBoostingStrategy;
import com.atlassian.confluence.plugins.search.boosting.EmptyScorer;
import com.atlassian.confluence.search.lucene.WrappingQuery;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.lucene.boosting.BoostingStrategy;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class BoostingQuery
extends WrappingQuery {
    private final Query contextQuery;
    private final SearchQueryParameters searchQueryParameters;
    private final BoostingStrategy boostStrategy;

    public BoostingQuery(Query contextQuery, SearchQueryParameters searchQueryParameters, BoostingStrategy boostStrategy) {
        super(contextQuery);
        this.contextQuery = contextQuery;
        this.searchQueryParameters = searchQueryParameters;
        this.boostStrategy = boostStrategy;
    }

    public Query getContextQuery() {
        return this.contextQuery;
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return new BoostingQueryWeight(searcher);
    }

    public String toString(String field) {
        return this.contextQuery.toString();
    }

    public void extractTerms(Set<Term> terms) {
        this.contextQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrittenContextQuery = this.contextQuery.rewrite(reader);
        if (rewrittenContextQuery == this.contextQuery) {
            return this;
        }
        return new BoostingQuery(rewrittenContextQuery, this.searchQueryParameters, this.boostStrategy);
    }

    private class BoostingQueryScorer
    extends Scorer {
        private final IndexReader reader;
        private final Scorer delegate;

        public BoostingQueryScorer(Weight weight, IndexReader reader, Scorer delegate) {
            super(weight);
            this.reader = reader;
            this.delegate = delegate;
        }

        public float score() throws IOException {
            return BoostingQuery.this.boostStrategy.boost(this.reader, BoostingQuery.this.searchQueryParameters, this.delegate.docID(), this.delegate.score());
        }

        public int freq() throws IOException {
            return this.delegate.freq();
        }

        public int docID() {
            return this.delegate.docID();
        }

        public int nextDoc() throws IOException {
            return this.delegate.nextDoc();
        }

        public int advance(int target) throws IOException {
            return this.delegate.advance(target);
        }

        public long cost() {
            return this.delegate.cost();
        }
    }

    private class BoostingQueryWeight
    extends Weight {
        private final Weight weight;

        public BoostingQueryWeight(IndexSearcher searcher) throws IOException {
            this.weight = BoostingQuery.this.contextQuery.createWeight(searcher);
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            Explanation result = this.weight.explain(context, doc);
            Scorer boostingScorer = this.scorer(context, true, false, context.reader().getLiveDocs());
            if (!(boostingScorer instanceof BoostingQueryScorer)) {
                return result;
            }
            int newDoc = boostingScorer.advance(doc);
            if (newDoc == doc) {
                result = ((ExplainableBoostingStrategy)BoostingQuery.this.boostStrategy).explain(context, doc, result);
                return result;
            }
            return new ComplexExplanation(false, 0.0f, "no matching term");
        }

        public Query getQuery() {
            return BoostingQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            return this.weight.getValueForNormalization();
        }

        public void normalize(float norm, float topLevelBoost) {
            this.weight.normalize(norm, topLevelBoost *= BoostingQuery.this.getBoost());
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            Scorer contextScorer = this.weight.scorer(context, scoreDocsInOrder, topScorer, acceptDocs);
            if (contextScorer != null) {
                return new BoostingQueryScorer(this, (IndexReader)context.reader(), contextScorer);
            }
            return new EmptyScorer(this);
        }
    }
}

