var RY = RY || {};

RY.MobileView = Backbone.View.extend({
    tagName: 'div',

    initialize: function(options) {
        this.$appframe = options.$appframe || $('#inner-container .container');
        if (this.$appframe.length === 0) {
            return; // Do not run code if mobile appframe not present on page
        }
        this.showLoading();

        _.bindAll(this, "showLoading", "render", "errorMsg", "filter");

        this.collection.fetch({
            success: this.render,
            error: this.errorMsg
        });

        this.$appframe.html(this.$el);

        this.collection.on("filter", this.filter, this);
    },

    showLoading: function() {
        this.$el.html(Confluence.Templates.Mobile.App.loadingIndicator());
    },

    template: RY.Templates.Mobile.listing,

    render: function() {
        this.collection.each(function(item) {
            item.set({ daysSince: item.daysSinceLastSeen() });
        });

        var html = this.template(this.getPartitionedData(this.collection));
        this.$el.html(html);

        if (this.collection.length > 0) {
            // initialize filtering and navigation
            var navigationEvents = _.extend({}, Backbone.Events);

            var filterView = new RY.FilterView({
                collection: this.collection,
                el: this.$appframe.find(".filter"),
                navigationEvents: navigationEvents
            }).render();
        }
    },

    /*
     * Partitions the pages collection into three arrays of objects that can be passed to the SOY template, the three
     * partitions correspond to pages viewed today, yesterday and older than that
     */
    getPartitionedData: function(pages) {
        pages = pages.toJSON();

        var today = _.filter(pages, function(page) { return page.daysSince === 0; } );
        var yesterday = _.filter(pages, function(page) { return page.daysSince === 1; } );
        var older = _.filter(pages, function(page) {
            return page.daysSince > 1;
        });

        return {
            today: today,
            yesterday: yesterday,
            older: older
        };
    },

    errorMsg: function() {
        // Template will render "Error". Not possible to provide supplementary error message because AJS.i18N does
        // not exist in mobile, so translation does not work
        this.$appframe.html(Confluence.Templates.Mobile.App.loadingError({
            message: ""
        }));
    },

    filter: function(pages, query) {
        var collection = new RY.PageCollection(pages);
        this.$('#stream-items li:not(:first-child)').remove(); // remove all results but leave page filter
        this.$('#stream-items').append(RY.Templates.Mobile.items(this.getPartitionedData(collection)));
    }
});

/* Integrate with Confluence Mobile web application (modified from Workday mobile) */
$(function() {
    RY.recentlyViewed = function() {
        ConfluenceMobile.router._resetFixtures();
        var collection = new RY.PageCollection();
        var mobileView = new RY.MobileView({
            collection: collection,
            $appframe: $('#inner-container .container')
        });
    };

    // Plug into the mobile app Backbone Router
    if (!(ConfluenceMobile && ConfluenceMobile.router && ConfluenceMobile.router.addRoute)) {
        ConfluenceMobile.router.addRoute = function(route, name, callback) {
            ConfluenceMobile.router.route(route, name, _.bind(callback, RY));

            if (ConfluenceMobile.DesktopSwitch && ConfluenceMobile.DesktopSwitch._routeToUrlMappers) {
                ConfluenceMobile.DesktopSwitch._routeToUrlMappers[name] = function() {
                    return 'dashboard.action';
                };
            }

            if (Backbone.history.getFragment().match(route.replace(/(:.*)/, '(.*)') + "$")) {
                // browser is targeting new route, after the router was started but before the new route was added
                // so let's load the URL again to invoke the new route
                Backbone.history.loadUrl();
            }
        };
    }

    ConfluenceMobile.router.addRoute('recentlyviewed', 'recentlyviewed', RY.recentlyViewed);
});
/* End Integrate with Confluence Mobile web application */