var RY = RY || {};

(function() {
    var temp = new Date();
    var now = new Date(temp).getTime();
    var today = new Date(temp.getFullYear(), temp.getMonth(), temp.getDate()).getTime();
    var yesterday = new Date(temp.getFullYear(), temp.getMonth(), temp.getDate() - 1).getTime();

    /**
     * Escapes regular expressions.
     *
     * @param str
     * @return {*}
     */
    RY.util = RY.Util = {
        analytics: {
            trackDialogOpen: function() {
              AJS.trigger("analytics", { name: "recently-viewed-dialog-open" });
            },

            trackPageOpen: function() {
              AJS.trigger("analytics", { name: "recently-viewed-page-open" });
            }

        },

        quote: function(str) {
            return (str).replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1");
        },

        diffInDays: function(date1, date2) {
            var MS_PER_DAY = 1000 * 60 * 60 * 24;
            return Math.floor((date1 - date2) / MS_PER_DAY);
        },

        daysSince: function(date) {
            if (date >= today) {
                return 0;
            } else if (date >= yesterday) {
                return 1;
            } else {
                return RY.util.diffInDays(now, date);
            }
        },

        /**
         * Creates and returns a new function that waits for function execution until the function
         * has not been called for wait seconds.
         *
         * @param fn
         * @param wait
         * @param context
         * @return {Function}
         */
        wait: function(fn, wait, context) {
            var last, timer, args;

            var startTimer = function() {
                timer = setTimeout(function () {
                    fn.apply(context, args);
                }, wait);
            };

            return function() {
                args = arguments;
                var now = new Date();
                if (last && now - last < wait) {
                    clearTimeout(timer);
                }
                startTimer();
                last = now;
            };
        }
    };
}());
