/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.naturalchildren;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.adaptavist.confluence.naturalchildren.PageAncestorList;
import com.adaptavist.confluence.naturalchildren.PageTree;
import com.adaptavist.confluence.naturalchildren.SearchResultsAncestorList;
import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResultType;
import com.atlassian.confluence.search.v2.searchfilter.InSpaceSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.SiteSearchPermissionsSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.TermSearchFilter;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageTreeBuilder {
    private static final Logger log = LoggerFactory.getLogger(PageTreeBuilder.class);
    private final SearchManager searchManager;
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private static final HashSet<String> SEARCH_FIELDS = new HashSet<String>(Arrays.asList("handle", "title", "ancestorIds", "created", "modified", "type", "position"));

    public PageTreeBuilder(SearchManager searchManager, PageManager pageManager, PermissionManager permissionManager) {
        this.searchManager = searchManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
    }

    private Page buildPage(Map<String, String[]> doc, Space space) {
        Page page = new Page();
        page.setTitle(this.extractStringValue(doc.get("title")));
        page.setId(this.extractPageId(doc.get("handle")));
        page.setSpace(space);
        page.setCreationDate(this.extractDate(doc.get("created")));
        page.setLastModificationDate(this.extractDate(doc.get("modified")));
        page.setPosition(this.extractPositionValue(doc.get("position")));
        return page;
    }

    private Date extractDate(String[] values) {
        return LuceneUtils.stringToDate((String)this.extractStringValue(values));
    }

    private Integer extractPositionValue(String[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        String value = values[0];
        try {
            return StringUtils.isNotEmpty((CharSequence)value) ? Integer.parseInt(value) : -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String extractStringValue(String[] values) {
        if (values == null || values.length == 0) {
            return "";
        }
        return values[0];
    }

    private long extractPageId(String[] values) {
        String value = this.extractStringValue(values);
        try {
            HibernateHandle hibernateHandle = new HibernateHandle(value);
            return hibernateHandle.getId();
        }
        catch (ParseException e) {
            log.warn("Unable to parse page id from the handle: {}, message: ", (Object)value, (Object)e.getMessage());
            return 0L;
        }
    }

    private PageTree searchAndBuildPageTreeHierarchy(User currentUser, Space space, SearchFilter searchFilter, boolean useSortPosition, Long currentPageId) throws InvalidSearchException {
        PageTree pageTree = new PageTree();
        HashMap<Long, Page> allPages = new HashMap<Long, Page>();
        AtomicReference<Boolean> hasNullPositions = new AtomicReference<Boolean>(false);
        this.searchManager.scan(searchFilter, SEARCH_FIELDS, doc -> {
            Page page = this.buildPage((Map<String, String[]>)doc, space);
            SearchResultsAncestorList ancestorList = new SearchResultsAncestorList((String[])doc.get("ancestorIds"));
            pageTree.addPage(ancestorList, page);
            if (page.getPosition() == null && !((Boolean)hasNullPositions.get()).booleanValue()) {
                hasNullPositions.set(true);
            }
            allPages.put(page.getId(), page);
        });
        if (currentPageId != null && !allPages.containsKey(currentPageId)) {
            this.addExistingPageToTheTree(currentUser, pageTree, currentPageId);
        }
        if (useSortPosition && hasNullPositions.get().booleanValue()) {
            this.updatePositionsInPages(space, allPages);
        }
        return pageTree;
    }

    private void addExistingPageToTheTree(User currentUser, PageTree pageTree, Long pageId) {
        Page page = this.pageManager.getPage(pageId.longValue());
        if (page == null) {
            return;
        }
        if (!this.permissionManager.hasPermission(currentUser, Permission.VIEW, (Object)page)) {
            return;
        }
        PageAncestorList ancestorList = new PageAncestorList(page.getAncestors(), page);
        pageTree.addPage(ancestorList, page);
    }

    private void updatePositionsInPages(Space space, Map<Long, Page> allPages) {
        List dbPages = this.pageManager.getPages(space, true);
        for (Page dbPage : dbPages) {
            Page page = allPages.get(dbPage.getId());
            if (page == null) continue;
            page.setPosition(dbPage.getPosition());
        }
    }

    PageTree buildPageTree(User currentUser, AbstractPage page, boolean useSortPosition, Long currentPageId) throws InvalidSearchException {
        SearchFilter searchFilter = new TermSearchFilter("type", "page").and((SearchFilter)new TermSearchFilter("ancestorIds", Long.toString(page.getId()))).and((SearchFilter)SiteSearchPermissionsSearchFilter.getInstance());
        return this.searchAndBuildPageTreeHierarchy(currentUser, page.getSpace(), searchFilter, useSortPosition, currentPageId);
    }

    PageTree buildPageTree(User currentUser, Space space, boolean useSortPosition, Long currentPageId) throws InvalidSearchException {
        SearchFilter searchFilter = new TermSearchFilter("type", "page").and(new InSpaceSearchFilter(Collections.singleton(space.getKey())).and((SearchFilter)new TermSearchFilter("confluence-document-type", SearchResultType.CONTENT.name())).and((SearchFilter)SiteSearchPermissionsSearchFilter.getInstance()));
        return this.searchAndBuildPageTreeHierarchy(currentUser, space, searchFilter, useSortPosition, currentPageId);
    }
}

