/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.naturalchildren;

import com.adaptavist.confluence.naturalchildren.NaturalPageComparator;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.ChildPositionComparator;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.ChildrenAction;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.ContentCreationComparator;
import com.atlassian.confluence.util.ContentEntityObjectTitleComparator;
import com.atlassian.confluence.util.ContentModificationComparator;
import com.atlassian.confluence.util.ExcerptHelper;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaturalChildrenAction
extends ChildrenAction {
    private static final Logger log = LoggerFactory.getLogger(NaturalChildrenAction.class);
    private static final String EXCERPT_KEY = "confluence.excerpt";
    private ContentPropertyManager contentPropertyManager;
    private XhtmlContent xhtmlContent;
    private PageManager pageManager;
    private ExcerptHelper excerptHelper;
    private Boolean excerpt;
    private Boolean reverse;
    private String sort;
    private String treeId;
    private Long treePageId;
    private String[] ancestors;
    private String spaceKey;
    private int startDepth;
    private boolean hasRoot;
    private boolean disableLinks;
    private boolean mobile;
    private boolean expandCurrent;
    private List<Long> idsToExpand = new ArrayList<Long>();
    public static final String SORT_BITWISE = "bitwise";
    public static final String SORT_CREATION = "creation";
    public static final String SORT_MODIFIED = "modified";
    public static final String SORT_NATURAL = "natural";
    public static final String SORT_POSITION = "position";
    public static final String SORT_DEFAULT = "position";

    public void setXhtmlContent(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    public void setPageManager(PageManager pageManager) {
        super.setPageManager(pageManager);
        this.pageManager = pageManager;
    }

    public void setExcerptHelper(ExcerptHelper excerptHelper) {
        this.excerptHelper = excerptHelper;
    }

    public String getPageExcerptHtml(Page page) {
        String excerpt = this.excerptHelper.getExcerpt((ContentEntityObject)page);
        if (StringUtils.isBlank((String)excerpt)) {
            return "";
        }
        PageContext renderContext = page.toPageContext();
        renderContext.pushRenderMode(RenderMode.suppress((long)256L));
        DefaultConversionContext excerptConversionContext = new DefaultConversionContext((RenderContext)renderContext);
        try {
            excerpt = this.xhtmlContent.convertStorageToView(excerpt, (ConversionContext)excerptConversionContext);
        }
        catch (XMLStreamException e) {
            excerpt = this.handleError(excerpt, e);
        }
        catch (XhtmlException e) {
            excerpt = this.handleError(excerpt, (Exception)((Object)e));
        }
        renderContext.popRenderMode();
        return excerpt;
    }

    private String handleError(String excerpt, Exception exception) {
        log.warn("Error rendering wiki link: [" + excerpt + "]", (Throwable)exception);
        return String.format("<span class=\"error\">%s</span>", HtmlUtil.htmlEncode((String)excerpt));
    }

    public void setExcerpt(Boolean bool) {
        this.excerpt = bool;
    }

    public String doDefault() throws Exception {
        if (!super.isPermitted()) {
            return "error";
        }
        if (this.expandCurrent) {
            this.idsToExpand.add(this.treePageId);
        }
        return super.doDefault();
    }

    public boolean isPermitted() {
        return true;
    }

    public Boolean getExcerpt() {
        return this.excerpt;
    }

    public void setTreeId(String tid) {
        this.treeId = tid;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public void setAncestors(String[] ancestors) {
        this.ancestors = ancestors;
    }

    public String[] getAncestors() {
        return this.ancestors;
    }

    public void setStartDepth(int startDepth) {
        this.startDepth = startDepth;
    }

    public int getStartDepth() {
        return this.startDepth;
    }

    public void setReverse(Boolean bool) {
        this.reverse = bool;
    }

    public void setSort(String sortOrder) {
        this.sort = sortOrder;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public boolean hasRoot() {
        return this.hasRoot;
    }

    public void setHasRoot(boolean hasRoot) {
        this.hasRoot = hasRoot;
    }

    public boolean getDisableLinks() {
        return this.disableLinks;
    }

    public void setDisableLinks(boolean disableLinks) {
        this.disableLinks = disableLinks;
    }

    public boolean isMobile() {
        return this.mobile;
    }

    public void setMobile(boolean mobile) {
        this.mobile = mobile;
    }

    public void setTreePageId(Long treePageId) {
        this.treePageId = treePageId;
    }

    public void setExpandCurrent(boolean expandCurrent) {
        this.expandCurrent = expandCurrent;
    }

    public List<Long> getIdsToExpand() {
        return this.idsToExpand;
    }

    public List getPermittedChildren(Page page) {
        AbstractPage original = super.getPage();
        super.setPage((AbstractPage)page);
        ArrayList permittedEntities = new ArrayList(this.getPermittedChildrenFromSuperClass());
        this.sortList(permittedEntities, this.sort, this.reverse);
        super.setPage(original);
        return permittedEntities;
    }

    protected List getPermittedChildrenFromSuperClass() {
        return super.getPermittedChildren();
    }

    public boolean hasPermittedChildren(Page page) {
        return super.hasPermittedChildren(page);
    }

    public boolean isAncestorPage(Page page) {
        String pageId = page.getIdAsString();
        if (StringUtils.isEmpty((String)pageId) || this.ancestors == null || this.ancestors.length <= 0) {
            return false;
        }
        for (int i = 0; i < this.ancestors.length; ++i) {
            if (!pageId.equals(this.ancestors[i])) continue;
            return true;
        }
        return false;
    }

    public List getAllPermittedStartPages(String spaceKey) {
        if (StringUtils.isEmpty((String)spaceKey)) {
            return Collections.EMPTY_LIST;
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        List topLevelPages = this.pageManager.getTopLevelPages(space);
        if (CollectionUtils.isEmpty((Collection)topLevelPages)) {
            return Collections.EMPTY_LIST;
        }
        List filteredList = this.permissionManager.getPermittedEntities((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, topLevelPages);
        this.sortList(filteredList, this.sort, this.reverse);
        return filteredList;
    }

    private void sortList(List pageList, String sortType, Boolean isReverse) {
        if (SORT_BITWISE.equals(sortType)) {
            Collections.sort(pageList, ContentEntityObjectTitleComparator.getInstance());
        } else if (SORT_CREATION.equals(sortType)) {
            Collections.sort(pageList, new ContentCreationComparator());
        } else if (SORT_MODIFIED.equals(sortType)) {
            Collections.sort(pageList, new ContentModificationComparator());
        } else if (SORT_NATURAL.equals(sortType)) {
            Collections.sort(pageList, new NaturalPageComparator());
        } else if ("position".equals(sortType)) {
            Collections.sort(pageList, new ChildPositionComparator());
        }
        if (isReverse == Boolean.TRUE) {
            Collections.reverse(pageList);
        }
    }
}

