AJS.PageGadget = {

    // use a method that works in IE, until AJS-384 is fixed
    loadTemplate : function(name) {
        return AJS.template(AJS.$("script[title='" + name + "']")[0].text);
    },

    pagePicker : function(gadget) {
        var pageName = gadget.getPref("pageName"),
            pageId = gadget.getPref("pageId"),
            pageDescription = gadget.getMsg("gadget.confluence.quickfind.page.name.description");

        /* Requires userpref to have pagename userpref as pageName
         * and spacekey userpref as spaceKey */
        return {
            userpref: "pageId",
            label: gadget.getMsg("gadget.confluence.quickfind.page.name.label"),
            description: pageDescription,
            id: "page-picker",
            type: "callbackBuilder",
            callback: function(parentDiv){
                var templateParams = {
                    pageId : pageId,
                    pageName: pageName,
                    pageDescription: pageDescription
                };
                parentDiv.append(AJS.PageGadget.loadTemplate("pagePicker").fillHtml(templateParams));

                var makeParams = function(val) {
                    return AJS.$.param({
                        type: "page,blogpost",
                        // Need to do that for compatible with both old and new version of AUI
                        query: AJS.escape ? AJS.escape(val) : AJS.escapeHtml(val)
                    });
                };

                AJS.PageGadget.doPageQuickFind(makeParams, gadget, templateParams);
            }
        };
    },

    clearPagePickerValues : function () {
        AJS.$("#pageId").val("");
        AJS.$("#pageName").val("");
        AJS.$("#quickfind-page").focus();
    },

    spacePicker : function(gadget) {
        var spaceKey = gadget.getPref("spaceKey"),
            spaceName = gadget.getPref("spaceName"),
            description = gadget.getMsg("gadget.confluence.quickfind.space.name.description");

        /* Requires userpref to have pagename userpref as pageName
         * and spacekey userpref as spaceKey */
        return {
            userpref: "spaceKey",
            label: gadget.getMsg("gadget.confluence.quickfind.space.name.label"),
            description: description,
            id: "space-picker",
            type: "callbackBuilder",
            callback: function(parentDiv){
                var defaultSpaceText = gadget.getMsg("gadget.confluence.quickfind.space.search.default"),
                    templateParams = {
                        spaceKey : spaceKey,
                        spaceName : spaceName,
                        spaceDescription: description,
                        i18nAllSpaces : defaultSpaceText,
                        spaceValue : spaceName || ""
                    };

                parentDiv.append(AJS.PageGadget.loadTemplate("spacePicker").fillHtml(templateParams));
                AJS.Confluence.Binder.placeholder(); // TODO: remove when upgrading to AUI 3.1
                
                var container = AJS.$("#quickfind-space-container"),
                    spaceField = AJS.$("#quickfind-space");

                spaceField.bind("reset.default-text", function() {
                    AJS.$("#spaceKey").val(""); // sync up the hidden field
                });

                var selectionHandler = function (e, selected) {
                    if (selected) {
                        this.hide("selected");

                        // Set space name
                        var restObj = selected.find("span").data("properties").restObj;
                        var spaceName = restObj.name;
                        AJS.$("#spaceName").val(spaceName);
                        spaceField.val(spaceName);

                        // Set spacekey
                        var spaceKey = restObj.key;
                        var oldSpaceKey = AJS.$("#spaceKey").val();
                        AJS.$("#spaceKey").val(spaceKey);

                        var currentValues = {};
                        if (spaceKey == oldSpaceKey) {
                            currentValues.pageName =  AJS.$("#pageName").val();
                            currentValues.pageId =  AJS.$("#pageId").val();
                        }

                        AJS.PageGadget.doPageQuickFind(function(val) {
                            return AJS.$.param({
                                type: "page,blogpost",
                                spaceKey: AJS.$("#spaceKey").val(),
                                // Need to do that for compatible with both old and new version of AUI
                                query: AJS.escape ? AJS.escape(val) : AJS.escapeHtml(val)
                            });
                        }, gadget, currentValues);

                        if (!currentValues.pageName) {
                            AJS.PageGadget.clearPagePickerValues();
                        }
                        e.preventDefault();
                    }
                };

                var makeParams = function(val) {
                    return AJS.$.param({
                        type: "spacedesc,personalspacedesc",
                        // Need to do that for compatible with both old and new version of AUI
                        query: AJS.escape ? AJS.escape(val) : AJS.escapeHtml(val)
                    });
                };

                var noMatch = gadget.getMsg("gadget.confluence.quickfind.space.search.no.matches");
                AJS.PageGadget.doQuickNav(spaceField, container, selectionHandler, makeParams, noMatch);
            }

        };
    },

    doPageQuickFind : function (makeParams, gadget, currentValues) {
        // Remove old quickfind
        AJS.$("#quickfind-page").remove();

        var container = AJS.$("#quickfind-page-container"),
            pageValue = "";
        if (currentValues && currentValues.pageId) {
            pageValue = currentValues.pageName;
        }
        container.prepend(AJS.PageGadget.loadTemplate("pageField").fillHtml({ pageValue : pageValue }));
        var pageField = AJS.$("#quickfind-page");

        // Define selection handler when dropdown item is selected
        var selectionHandler = function (e, selected) {
            if (selected) {
                this.hide("selected");

                // Remove page validation error if there is one
                AJS.$("#pageId-error").remove();

                var restObj = selected.find("span").data("properties").restObj;
                var pageName = restObj.title;

                // Set hidden <input>
                AJS.$("#pageName").val(pageName);
                AJS.$("#pageId").val(restObj.id);
                AJS.$("#spaceKey").val(restObj.space.key);

                pageField.val(pageName).blur();
                e.preventDefault();
            }
        };

        var noMatch = gadget.getMsg("gadget.confluence.quickfind.page.search.no.matches");

        AJS.PageGadget.doQuickNav(pageField, container, selectionHandler, makeParams, noMatch);
    },

    doQuickNav : function (field, container, selectionHandler, makeParams, noMatch) {
        var onShow = function() {
            AJS.$("div.aui-shadow-parent").remove();
            var dropdown = AJS.$("div.aui-dd-parent", container);

            var bottomOfDropdown = dropdown.offset().top + dropdown.height() + 3;
            if (AJS.$(window).height() < bottomOfDropdown) {
                gadgets.window.adjustHeight(bottomOfDropdown);
            }
        };

        var options = {
            makeParams: makeParams,
            ajsDropDownOptions: {
                selectionHandler:  function (e, selected) {
                    var result = selectionHandler.call(this, e, selected);
                    gadgets.window.adjustHeight(AJS.$("#config").height());
                    return result;
                }
            },
            dropdownPostprocess: function (list) {
                if (!AJS.$("> ol", list).length) { // empty list
                    AJS.$(list).append(
                            AJS.$("<ol/>").addClass("no-match").append(
                                    AJS.$("<li/>").append(
                                            AJS.$("<span/>").html(noMatch)
                                            )
                                    )
                            );
                }
                AJS.$("> ol:last-child", list).addClass("last");
                AJS.$("a", list).attr("tabindex", "-1"); // prevent tabbing to links
            },
            dropdownPlacement: function (dropDown) {
                AJS.$(".search-drop-down", container).append(dropDown);
            },
            makeRestMatrixFromData: AJS.REST.makeRestMatrixFromSearchData
        };

        field.quicksearch("/rest/prototype/1/search/name.json", onShow, options);
    },

    resizeGadget : function () {
        var flashCheckCounter = 0;

        // Calculates the height and executes resize
        var doResize = function() {
            var height = AJS.PageGadget.iFrame.contents().find("#content").outerHeight();
            var body = AJS.$("body");
            height += parseInt(body.css("padding-bottom"), 10) + parseInt(body.css("padding-top"),10);

            // Minimum height of 100px
            if (height) {
                // Adding 20 to account for the horizontal scrollbar
                gadgets.window.adjustHeight(Math.max(100, height + 20));
            }

            AJS.PageGadget.iFrame.removeClass("resizing");
        }

        // Checks all flash objects have been loaded
        var areFlashFramesLoaded = function(slides) {
            for(var i = 0,ii = slides.length; i < ii; i++) {
                if(!AJS.$(slides[i]).find("object").outerHeight()) {
                    return false;
                }
            }
            return true;
        }

        // Wait for flash objects to load then resize
        var resizeAfterFlashFramesLoad = function() {
            var slides = AJS.PageGadget.iFrame.contents().find("#Slides");
            if (!areFlashFramesLoaded(slides) && ++flashCheckCounter < 20) { // upper limit check for flash frames loaded
                var callee = arguments.callee;
                setTimeout(function() { callee(); } , 500);
                return;
            }
            doResize();
        }

        AJS.PageGadget.iFrame.addClass("resizing");
        // Find all Confluence flash elements
        var nSlides = AJS.PageGadget.iFrame.contents().find("#Slides").length;
        if (nSlides) {
            resizeAfterFlashFramesLoad();
        } else {
            doResize();
        }
    },

    addLinks : function () {
        var links = AJS.PageGadget.links;
        if (links.length == 0) {
            return;
        }

        var linkContainer = AJS.$("#confluence-page").contents().find("#page-links ol");

        for (var i in links) {
            linkContainer.append(AJS.PageGadget.loadTemplate("pageLink").fillHtml(links[i]))
        }

        // Used if styling changes depending on the number of items
        AJS.$("#page-links li").addClass("list-length-" + links.length);
    }
};


AJS.toInit(function ($) {
    var gadget = AJS.Gadget({
        baseUrl: AJS.params.contextPath,
        useOauth: "/rest/gadget/1.0/currentUser",
        config: {
            descriptor: function () {
                var gadget = this;

                return {
                    action: "/rest/gadget/1.0/pagegadget/validate.json",
                    fields: [
                        AJS.PageGadget.spacePicker(gadget),
                        AJS.PageGadget.pagePicker(gadget),
                        {
                            id: "show-link",
                            userpref: "showLink",
                            type: "checkbox",
                            options:[
                                {
                                    id: "showLink",
                                    label: gadget.getMsg("gadget.confluence.page.showlink"),
                                    selected: gadget.getPref("showLink") == "true",
                                    value: "true"
                                }
                            ]
                        },
                        {
                            id: "is-editable",
                            userpref: "isEditable",
                            type: "checkbox",
                            options:[
                                {
                                    id: "isEditable",
                                    label: gadget.getMsg("gadget.confluence.page.isEditable"),
                                    selected: gadget.getPref("isEditable") == "true",
                                    value: "true"
                                }
                            ]
                        },
                        AJS.gadget.fields.nowConfigured()
                    ]
                };
            }
        },
        view: {
            enableReload: true,
            onResizeAdjustHeight: true,
            template: function(args) {
                var gadget = this,
                    pageId = gadget.getPref("pageId");
                var initGadget = function(data) {

                    // CGP-136: Order matters. We need to populate the links preferences
                    // before the adding links code executes in the iframe. 
                    var links = [];
                    if (gadget.getPref("showLink") == "true") {
                        links.push({
                            id : "viewLink",
                            href : AJS.contextPath() + "/pages/viewpage.action?pageId=" + pageId,
                            label : gadget.getMsg("gadget.confluence.page.view"),
                            iconClass : "view-icon"
                        });
                    }

                    if (data.userCanEditPage && gadget.getPref("isEditable") == "true") {
                        links.push({
                            id : "editLink",
                            href : AJS.contextPath() + "/pages/edit" + data.contentType + ".action?pageId=" + pageId,
                            label : gadget.getMsg("gadget.confluence.page.edit"),
                            iconClass : "edit-icon"
                        });
                    }

                    AJS.PageGadget.links = links;

                    gadgets.window.setTitle(data.pageTitle);

                    var view = gadget.getView().empty();
                    var origFrame = AJS.$("<iframe/>").attr("id", "confluence-page").attr("name", "confluence-page");
                    AJS.PageGadget.iFrame = origFrame;

                    view.append(origFrame);

                    // The current "best" method, stolen from the jsonp implementation.
                    var window = origFrame[0].contentWindow || tmp.contentDocument,
                        document = window.document;

                    document.open();
                    document.write(data.html);
                    document.close();
                };

                AJS.$.ajax({
                    url: "/rest/gadget/1.0/pagegadget/getrenderedpage.json",
                    type: "GET",
                    dataType: "json",
                    data: {
                        pageId: pageId
                    },
                    success: function(data) {
                        initGadget(data);
                    },
                    error: function(err, text) {
                        if (err.status === 401)
                            gadget.showMessage("warning", gadget.getMsg("gadget.confluence.page.permission.error"), false);

                        AJS.log('Error loading page');
                        // Default height when there are errors.
                        gadgets.window.adjustHeight(200);
                    }
                });
            }
        }
    });

});
