// Javascript to be loaded in the page iframe
AJS.toInit( function ($) {
    var contextPath = AJS.contextPath();
    var pageUrl = AJS.params.pageUrl;

    // Just to make things simpler.
    AJS.PageGadget = window.parent.AJS.PageGadget;
    AJS.PageGadget.addLinks();

    // You only need to update links if we're in a different container
    var updateLinks = !(window.parent.atlassian.util.getRendererBaseUrl() == AJS.params.baseUrl);

    $(window).bind('contentsUpdated', function(){
        $("#content a[data-processed!=true]").each(function (){
            $(this).attr("target", "_blank");

            if (updateLinks) {
                var url = $(this).attr("href");

                if (url) {
                    var serverUrl = AJS.params.serverUrl;
                    if(url.charAt(serverUrl.length + 1) == "#"){  //Anchor detected
                        url = contextPath + pageUrl + url.substring(serverUrl.length, url.length);
                        $(this).attr("href", url);
                    }else if (url.indexOf("http") != 0) {
                        $(this).attr("href", serverUrl + url);
                    }
                }
            }

            $(this).attr("data-processed", "true");
        });
        
        AJS.PageGadget.resizeGadget();
    });

    AJS.PageGadget.contentsUpdated = function () {
        AJS.$(window).trigger("contentsUpdated");
    };
    
    AJS.PageGadget.contentsUpdated();
});

/**
 * In order for ajax calls to work outside of the confluence instance we need
 * to hook into the gadget ajax implementation in the parent iframe.
 */
AJS.$.fn.serializeArray = window.parent.AJS.$.fn.serializeArray;

AJS.$.extend({

    put: window.parent.AJS.$.put,

    del: window.parent.AJS.$.del,

    /**
     * @method put
     * @param url
     * @param data
     * @param callback
     * @param type
     */
    get: function (url, data, callback, type) {
        if ( jQuery.isFunction( data ) ) {
			callback = data;
			data = {};
		}

        if (!type) {
            type = "text";
        }

        return AJS.$.ajax({
			type: "GET",
			url: url,
			data: data,
			success: callback,
			dataType: type
		});
    },

	ajax: window.parent.AJS.$.ajax
});
