define("confluence-gadgets/gadget-directory-dialog", [
    "jquery",
    "ajs",
    "confluence/templates"
],
/**
 * Displays the gadgets dialog available from the Help Menu.
 * @param $
 * @param AJS
 * @param Templates
 * @returns {Function}
 */
function(
    $,
    AJS,
    Templates
) {
    "use strict";

    var GadgetDirectoryDialog = function() {};
    GadgetDirectoryDialog.prototype = {
        $dialog: null,
        dlg: null,
        gadgetList: null,

        insertContent: function() {
            this.$dialog.find(".aui-dialog2-content").append(this.buildDirectoryHelp()).append(this.buildDirectoryList());
        },

        buildDirectoryHelp: function() {
            return Templates.GadgetDirectory.directoryHelp();
        },

        buildDirectoryList: function() {
            return Templates.GadgetDirectory.directoryList({ gadgetList: this.gadgetList });
        },

        loadDirectory: function() {
            var self = this;

            if (this.dlg) {
                this.dlg.show();
            } else {
                var closeButtonHTML = aui.buttons.button({
                    type: "link",
                    id: "gadget-directory-dialog-close",
                    text: AJS.I18n.getText("gadget.directory.close.button")
                });
                this.$dialog = $(aui.dialog.dialog2({
                    id: "gadget-directory-dialog",
                    size: "large",
                    titleText: AJS.I18n.getText("gadget.directory.title"),
                    modal: false,
                    footerActionContent: closeButtonHTML,
                    extraAttributes: {
                        "data-aui-focus-selector": "#gadget-directory-dialog-close"
                    }
                }));
                this.dlg = AJS.dialog2(this.$dialog);
                this.dlg.show();

                this.$dialog.on("click", "#gadget-directory-dialog-close", function() {
                    AJS.dialog2(self.$dialog).hide();
                });
                this.$dialog.find(".aui-dialog2-content").spin("large");

                AJS.$.ajax({
                    url: AJS.contextPath() + "/rest/gadget/1.0/published/gadgetsdirectory",
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        if (data.directoryList) {
                            self.gadgetList = data.directoryList;
                            self.gadgetList.forEach(function(gadget_item) {
                                gadget_item.id = "macro-" + gadget_item.title.split(' ').join('');
                            });
                        }

                        self.$dialog.find(".aui-dialog2-content").spinStop();
                        self.insertContent();
                    },
                    error: function() {
                        self.$dialog.find(".aui-dialog2-content").append("<div></div>").addClass("loading-error").html(AJS.messages.error({
                            body: AJS.I18n.getText("gadget.directory.loading.error"),
                            closeable: false
                        }));
                    },
                    timeout: 12000
                });
            }
        }
    };

    return GadgetDirectoryDialog;
});

require("confluence/module-exporter").safeRequire("confluence-gadgets/gadget-directory-dialog", function(GadgetDirectoryDialog) {
    "use strict";

    var GADGET_DIRECTORY = null;

    require('ajs').bind("deferred.available-gadgets.help-menu", function(e) {
        e.preventDefault();
        if (GADGET_DIRECTORY === null) {
            GADGET_DIRECTORY = new GadgetDirectoryDialog();
        }
        GADGET_DIRECTORY.loadDirectory();
    });
});
