package com.atlassian.confluence.plugins.requirements;

import com.atlassian.confluence.plugins.createcontent.api.contextproviders.AbstractBlueprintContextProvider;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContext;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.google.common.collect.ImmutableMap;

import java.util.Map;

/**
 * @since 1.2.4
 */
public class RequirementsIndexContextProvider extends AbstractBlueprintContextProvider {
    private TemplateRenderer templateRenderer;

    public RequirementsIndexContextProvider(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    @Override
    protected BlueprintContext updateBlueprintContext(BlueprintContext context) {
        Map<String, Object> soyContext = ImmutableMap.of(
                "blueprintKey", context.getBlueprintModuleCompleteKey().getCompleteKey(),
                "spaceKey", context.getSpaceKey(),
                "createFromTemplateLabel", context.getCreateFromTemplateLabel()
        );

        StringBuilder createFromTemplateMacro = new StringBuilder();
        templateRenderer.renderTo(createFromTemplateMacro,
                "com.atlassian.confluence.plugins.confluence-software-blueprints:requirements-resources",
                "Confluence.Blueprints.Requirements.createFromTemplateMacro.soy", soyContext);

        context.put("createFromTemplateMacro", createFromTemplateMacro.toString());

        return context;
    }
}
