Confluence.Blueprints.Restrospectives = (function ($) {
    var retroForm;
    var TITLE_DATE_FORMAT = "YYYY-MM-DD";

    var removeError = function (element) {
        element.siblings(".error").empty();
    };

    var showError = function (element, message) {
        element.focus().siblings(".error").text(message);
    };

    var isPageTitleValid = function () {
        if (retroForm.title.val() === "") {
            return true;
        }

        if (!Confluence.Blueprint.canCreatePage(retroForm.spaceKey, retroForm.title.val())) {
            showError(retroForm.title, AJS.I18n.getText('retrospectives.blueprint.form.validation.title.exits'));
            return false;
        }
        removeError(retroForm.title);
        return true;
    };

    var bindRetroFormElementsEvent = function () {
        retroForm.title.change(isPageTitleValid);
    };

    var generatePageTitle = function () {
        var requestTime = $("meta[name=confluence-request-time]").attr("content");
        var now = moment(parseFloat(requestTime)).format(TITLE_DATE_FORMAT);
        retroForm.title.val(now + ' ' + AJS.I18n.getText('retrospectives.blueprint.dialog.title.value'));
    };

    return {
        init: function (state) {
            retroForm = {
                title: state.$container.find('#retro-title'),
                participants: state.$container.find('#retro-participants'),
                spaceKey: state.wizardData.spaceKey
            };

            bindRetroFormElementsEvent();
            generatePageTitle();
        },

        validateRetroForm: function () {
            return isPageTitleValid();
        }

    };
})(AJS.$);