/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.retrospectives;

import com.atlassian.confluence.plugins.SoftwareBlueprintsContextProviderHelper;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.AbstractBlueprintContextProvider;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class RetrospectivesContextProvider
extends AbstractBlueprintContextProvider {
    public static final String TEMPLATE_PROVIDER_PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-software-blueprints:retrospective-resources";
    private static final String USER_LIST_TEMPLATE = "Confluence.Blueprints.Common.userList.soy";
    private static final String USERS_TEMPLATE = "Confluence.Blueprints.Common.users.soy";
    private static final String USER_TABLE_TEMPLATE = "Confluence.Blueprints.Common.userTable.soy";
    private static final String USERNAME_KEY = "names";
    private final SoftwareBlueprintsContextProviderHelper helper;

    public RetrospectivesContextProvider(SoftwareBlueprintsContextProviderHelper helper) {
        this.helper = helper;
    }

    protected BlueprintContext updateBlueprintContext(BlueprintContext context) {
        String participantParam = (String)context.get("retro-participants");
        HashMap<String, Object> soyContext = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)participantParam)) {
            soyContext.put(USERNAME_KEY, participantParam.split(","));
            context.put("participants", (Object)this.helper.renderFromSoy(TEMPLATE_PROVIDER_PLUGIN_KEY, USERS_TEMPLATE, soyContext));
            context.put("participantList", (Object)this.helper.renderFromSoy(TEMPLATE_PROVIDER_PLUGIN_KEY, USER_LIST_TEMPLATE, soyContext));
            context.put("participantTable", (Object)this.helper.renderFromSoy(TEMPLATE_PROVIDER_PLUGIN_KEY, USER_TABLE_TEMPLATE, soyContext));
        }
        context.setTitle((String)context.get("retro-title"));
        context.put("currentDate", (Object)this.helper.serverFormatDate(new Date()));
        context.put("currentDateLozenge", (Object)this.helper.createStorageFormatForToday());
        this.doAnalytic(participantParam);
        return context;
    }

    private void doAnalytic(String participants) {
        String username = AuthenticatedUserThreadLocal.getUsername();
        if (username != null && !username.equals(participants)) {
            this.helper.publishAnalyticEvent("confluence.software.blueprints.retrospective.participants");
        }
        this.helper.publishAnalyticEvent("confluence.software.blueprints.retrospective.create");
    }
}

