





* * *

## Class: MediaViewer
Core API to integrate MediaViewer into a project.

**VERSION**: `String` , Current version of this build.
### MediaViewer.registerPlugin(name, plugin) 

Register a new plugin for use with MediaViewer.

**Parameters**

**name**: `String`, Register a new plugin for use with MediaViewer.

**plugin**: `function`, Register a new plugin for use with MediaViewer.


### MediaViewer.isPluginEnabled(name) 

Returns if a plugin is enabled for use with MediaViewer.

**Parameters**

**name**: `String`, Returns if a plugin is enabled for use with MediaViewer.


### MediaViewer.getPlugin(name) 

Gets a plugin registered for use with MediaViewer.

**Parameters**

**name**: `String`, Gets a plugin registered for use with MediaViewer.


### MediaViewer.isPlugin(potentialPlugin) 

Checks if the given object is a valid plugin.

**Parameters**

**potentialPlugin**: `*`, Checks if the given object is a valid plugin.

**Returns**: `Boolean`

### MediaViewer.open(fileQuery, analyticsSource) 

Open this instance of MediaViewer by appending it to the configured element. This needs to be called
before showing a file.

When a fileQuery object is passed in, this file is shown and a special analytics event is triggered.
When you want to record, where this interaction is comming from, pass in
an additional analyticsSource

**Parameters**

**fileQuery**: `Object`, Open this instance of MediaViewer by appending it to the configured element. This needs to be called
before showing a file.

When a fileQuery object is passed in, this file is shown and a special analytics event is triggered.
When you want to record, where this interaction is comming from, pass in
an additional analyticsSource

**analyticsSource**: `String`, Open this instance of MediaViewer by appending it to the configured element. This needs to be called
before showing a file.

When a fileQuery object is passed in, this file is shown and a special analytics event is triggered.
When you want to record, where this interaction is comming from, pass in
an additional analyticsSource

**Fires**: {MediaViewer~event:&#39;fv.open&#39;}


### MediaViewer.close() 

Shut down this instance of MediaViewer by removing it from the configured element. Reset current file.

**Fires**: {MediaViewer~event:&#39;fv.close&#39;}


### MediaViewer.isOpen() 

Check if MediaViewer is currently open.

**Returns**: `Boolean`

### MediaViewer.showFileWithQuery(query) 

Show file that matches the given attribute query.

A query is basically a set of values for certain keys that you want to match on. To match the file with id='a'
and src='test'.

    {
    id: 'a',
    src: 'test'
    }

**Parameters**

**query**: `Object`, Show file that matches the given attribute query.

A query is basically a set of values for certain keys that you want to match on. To match the file with id='a'
and src='test'.

    {
    id: 'a',
    src: 'test'
    }

**Fires**: {MediaViewer~event:&#39;fv.changeFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFileError&#39;}

**Returns**: `Promise.&lt;File&gt;`

### MediaViewer.showFileNext() 

Show the next file in the collection.

**Fires**: {MediaViewer~event:&#39;fv.changeFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFileError&#39;}

**Returns**: `Promise.&lt;File&gt;`

### MediaViewer.showFilePrev() 

Show the previous file in the collection.

**Fires**: {MediaViewer~event:&#39;fv.changeFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFileError&#39;}

**Returns**: `Promise.&lt;File&gt;`

### MediaViewer.setFiles(newFiles, nextFileQuery) 

Set both the list of files as well as the current file.

Ensures that the updated current file is shown if the viewer is open. Viewer caching might prevent a full
re-render.

If no query is given or the query doesn't match a file in the collection, the current file is set to `null`,
causing an error message to be shown if the viewer is open.

**Parameters**

**newFiles**: `Array.&lt;Object&gt;`, Set both the list of files as well as the current file.

Ensures that the updated current file is shown if the viewer is open. Viewer caching might prevent a full
re-render.

If no query is given or the query doesn't match a file in the collection, the current file is set to `null`,
causing an error message to be shown if the viewer is open.

**nextFileQuery**: `Object`, Set both the list of files as well as the current file.

Ensures that the updated current file is shown if the viewer is open. Viewer caching might prevent a full
re-render.

If no query is given or the query doesn't match a file in the collection, the current file is set to `null`,
causing an error message to be shown if the viewer is open.

**Fires**: {MediaViewer~event:&#39;fv.setFiles&#39;}


### MediaViewer.getCurrent() 

Returns the file being shown in this viewer.

**Returns**: `Object`, the file being shown

### MediaViewer.getCurrentFile() 

Returns the file being shown in this viewer as a backbone model.

**Note**: This method is deprecated, because it exposes a backbone model. See #getCurrent() instead.

Deprecated: true

**Returns**: `File`, the file being shown

### MediaViewer.getFiles() 

Returns the current files collection.

**Returns**: `Array.&lt;Object&gt;`

### MediaViewer.isShowingFirstFile() 

Check if current file is the first one in the files collection.

**Returns**: `Boolean`

### MediaViewer.isShowingLastFile() 

Check if current file is the last one in the files collection.

**Returns**: `Boolean`

### MediaViewer.changeMode(mode) 

Change current view mode to the given mode.

**Parameters**

**mode**: `String`, either 'BASE', 'PRESENTATION' or 'CONTAINED'

**Fires**: {MediaViewer~event:&#39;fv.changeMode&#39;}


### MediaViewer.getMode() 

Return the current mode.

**Returns**: `String`

### MediaViewer.isInMode(mode) 

Check if MediaViewer is in the given mode.

**Parameters**

**mode**: `String`, either 'BASE', 'PRESENTATION' or 'CONTAINED'

**Returns**: `Boolean`

### MediaViewer.addFileAction(opts) 

Add a file action to the viewer.

Actions can be registered asynchronously, and are reset when the user navigates to a new file.

Commonly, a plugin will listen to the change file event and register a file action
conditionally for the displayed file. If a file action shares a key with a file
action that currently exists, addFileAction will replace the old action with the
new action.

**Parameters**

**opts**: `Object`, Add a file action to the viewer.

Actions can be registered asynchronously, and are reset when the user navigates to a new file.

Commonly, a plugin will listen to the change file event and register a file action
conditionally for the displayed file. If a file action shares a key with a file
action that currently exists, addFileAction will replace the old action with the
new action.

 - **opts.key**: `String`, a unique identifier for the file action

 - **opts.text**: `String`, the text display in the menu item

 - **opts.callback**: `MediaViewer~fileActionCallback`, a callback to be called when the menu item is selected


### MediaViewer.removeFileAction(opts) 

Remove a file action from the viewer based on the key sent in the parameter.

**Parameters**

**opts**: `Object`, Remove a file action from the viewer based on the key sent in the parameter.

 - **opts.key**: `String`, a unique identifier for the file action you want to remove


### MediaViewer.supports(contentType) 

Check if the MediaViewer supports native rendering of a given content type.

**Parameters**

**contentType**: `String`, the content type to check if supported

**Returns**: `Boolean`

### MediaViewer.set(key, value) 

Allows non-core code to get and set their own values on an instance of MediaViewer.

**Parameters**

**key**: `String`, Allows non-core code to get and set their own values on an instance of MediaViewer.

**value**: `*`, Allows non-core code to get and set their own values on an instance of MediaViewer.


### MediaViewer.get(key) 

Access plugin level properties.

**Parameters**

**key**: `String`, Access plugin level properties.

**Returns**: `*`

### MediaViewer.getConfig() 

Returns the specified config.

**Returns**: `Object`

### MediaViewer.getView() 

Returns the central view of MediaViewer.

**Returns**: `MainView`

### MediaViewer.getStorage() 

Returns key-value storage of MediaViewer.

**Returns**: `Object`

### MediaViewer.showFile(file) 

**DEPRECATED** Show the given file.

**Carefull**: This method doesn't set the current file from the collection and thus allows to set a file that
is not in the files array, thus causing buggy behaviour with next/prev file.

Use #showFileWithQuery() instead.

Deprecated: true

**Parameters**

**file**: `File`, **DEPRECATED** Show the given file.

**Carefull**: This method doesn't set the current file from the collection and thus allows to set a file that
is not in the files array, thus causing buggy behaviour with next/prev file.

Use #showFileWithQuery() instead.

**Fires**: {MediaViewer~event:&#39;fv.changeFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFileError&#39;}

**Returns**: `Promise.&lt;File&gt;`

### MediaViewer.showFileWithCID(cid) 

**DEPRECATED** Show the file matching the given backbone object id.

Use #showFileWithQuery() instead.

Deprecated: true

**Parameters**

**cid**: `String`, **DEPRECATED** Show the file matching the given backbone object id.

Use #showFileWithQuery() instead.

**Fires**: {MediaViewer~event:&#39;fv.changeFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFileError&#39;}

**Returns**: `Promise.&lt;File&gt;`

### MediaViewer.showFileWithId(id, ownerId) 

**DEPRECATED** Show the file matching the given id.

Use #showFileWithQuery() instead.

Deprecated: true

**Parameters**

**id**: `String`, **DEPRECATED** Show the file matching the given id.

Use #showFileWithQuery() instead.

**ownerId**: `String`, **DEPRECATED** Show the file matching the given id.

Use #showFileWithQuery() instead.

**Fires**: {MediaViewer~event:&#39;fv.changeFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFileError&#39;}

**Returns**: `Promise.&lt;File&gt;`

### MediaViewer.showFileWithSrc(src) 

**DEPRECATED** Show file with matching src.

Use #showFileWithQuery() instead.

Deprecated: true

**Parameters**

**src**: `String`, **DEPRECATED** Show file with matching src.

Use #showFileWithQuery() instead.

**Fires**: {MediaViewer~event:&#39;fv.changeFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFileError&#39;}

**Returns**: `Promise.&lt;File&gt;`

### MediaViewer.showFileWhere(selector) 

**DEPRECATED** Show the first file matching the given selector. If selector is falsy, the first file in the
collection is shown.

Use #showFileWithQuery() instead.

Deprecated: true

**Parameters**

**selector**: `Object`, **DEPRECATED** Show the first file matching the given selector. If selector is falsy, the first file in the
collection is shown.

Use #showFileWithQuery() instead.

**Fires**: {MediaViewer~event:&#39;fv.changeFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFile&#39;}

**Fires**: {MediaViewer~event:&#39;fv.showFileError&#39;}

**Returns**: `Promise.&lt;File&gt;`

### MediaViewer.updateFiles(files, mapFn) 

**DEPRECATED** Update the files collection without updating the view state.

**Carefull**: A call to `updateFiles()` neither changes the file currently shown nor causes a re-rendering. This
can cause state and view to get out of sync and is likely to introduce bugs. Therefore, this method should no
longer be used. See MediaViewer#setFiles() instead.

This method operates in two modes based on it's input.

When invoked with nothing but `files`, the existing file collection is simply replaced with the new one.

When an optional `mapFn` function is given, the behaviour changes drastically. Each file in the given `files`
array is compared with the already existing ones using `mapFn`.

- If a file existed before, but isn't matched by a new file, it won't be updated, but stays in the collection.
- If a file existed before and is matched by a new file, it is updated and stays in the collection.
- If a file didn't exist before, it is appended to the collection

Deprecated: true

**Parameters**

**files**: `Array.&lt;Object&gt;`, **DEPRECATED** Update the files collection without updating the view state.

**Carefull**: A call to `updateFiles()` neither changes the file currently shown nor causes a re-rendering. This
can cause state and view to get out of sync and is likely to introduce bugs. Therefore, this method should no
longer be used. See MediaViewer#setFiles() instead.

This method operates in two modes based on it's input.

When invoked with nothing but `files`, the existing file collection is simply replaced with the new one.

When an optional `mapFn` function is given, the behaviour changes drastically. Each file in the given `files`
array is compared with the already existing ones using `mapFn`.

- If a file existed before, but isn't matched by a new file, it won't be updated, but stays in the collection.
- If a file existed before and is matched by a new file, it is updated and stays in the collection.
- If a file didn't exist before, it is appended to the collection

**mapFn**: `MediaViewer~updateFilesMapFn`, **DEPRECATED** Update the files collection without updating the view state.

**Carefull**: A call to `updateFiles()` neither changes the file currently shown nor causes a re-rendering. This
can cause state and view to get out of sync and is likely to introduce bugs. Therefore, this method should no
longer be used. See MediaViewer#setFiles() instead.

This method operates in two modes based on it's input.

When invoked with nothing but `files`, the existing file collection is simply replaced with the new one.

When an optional `mapFn` function is given, the behaviour changes drastically. Each file in the given `files`
array is compared with the already existing ones using `mapFn`.

- If a file existed before, but isn't matched by a new file, it won't be updated, but stays in the collection.
- If a file existed before and is matched by a new file, it is updated and stays in the collection.
- If a file didn't exist before, it is appended to the collection

**Fires**: {MediaViewer~event:&#39;fv.updateFiles&#39;}

**Returns**: `Array.&lt;Object&gt;`



* * *
















* * *

## Class: MainView
Core view of MediaViewer.

### MainView.show() 

Show.

**Returns**: `MainView`, this

### MainView.hide() 

Hide.

**Returns**: `MainView`, this

### MainView.render() 

Render.

**Returns**: `MainView`, this

### MainView.showFile(file) 

Show the given file. If one of the following conditions is true

  1. file is invalid
  2. no viewer for that fileType is registered
  3. the viewer code can't be loaded
  4. the viewer couldn't be created

then the returned promise is rejected. In that case, fileView changes
state and displays the error internally.

When the new file and the current file have the same src and type attributes,
this method will not perform a re-rendering.

**Parameters**

**file**: `File`, Show the given file. If one of the following conditions is true

  1. file is invalid
  2. no viewer for that fileType is registered
  3. the viewer code can't be loaded
  4. the viewer couldn't be created

then the returned promise is rejected. In that case, fileView changes
state and displays the error internally.

When the new file and the current file have the same src and type attributes,
this method will not perform a re-rendering.

**Fires**: {MainView~event:&#39;fv.fileChange&#39;}

**Fires**: {MainView~event:&#39;cancelShow&#39;}

**Returns**: `Promise.&lt;File&gt;`, the given file

### MainView.getCurrentFile() 

Return the currently shown file.

**Returns**: `null | File`, the file being shown

### MainView.getViewState() 

Return the current view state.
Can be any of the following
loading, fileNotFound, fetchTokenError, viewerError, success

**Returns**: `String`

### MainView.lockNavigationKeys() 

Lock navigation keys. Navigation keys will be disabled until all
locks are removed again with unlockNavigationKeys.


### MainView.unlockNavigationKeys() 

Unlock navigation keys.


### MainView.isNavigationLocked() 

Checks if the navigation is locked.


### MainView.getMode() 

Return the current mode.

**Returns**: `string`

### MainView.isInMode(mode) 

Check if FileView is in the given mode.

**Parameters**

**mode**: `string`, either 'BASE', 'PRESENTATION' or 'CONTAINED'

**Returns**: `boolean`

### MainView.setupMode(mode) 

Change current view mode to the given mode.

**Parameters**

**mode**: `string`, either 'BASE', 'PRESENTATION' or 'CONTAINED'




* * *










