### 2.2.2 (2017-02-06)

### Fixes

- FIL-3611 close gracefully when there is an error opening the file
- FIL-3755 fix XSS vulnerability by replacing all ES6 strings with handlebar template
- FIL-3156 Keep Error overlay centered on small windows

## 2.2.1 (2016-12-24)

### Fixes

- FIL-3523 preserve file identidy in MediaViewer's fetchToken command

## 2.2.0 (2016-12-20)

### Features

- FIL-3259 add beta of the new contained mode required by BB Cloud

- FIL-3178 send resource timing analytic events files.fileviewer-web.file.resourceTiming.{success,failure}

- FIL-3462 send video stalled analytic events files.fileviewer-web.file.stalled

- FIL-3478 add fromMediaAPI attribute to all analytics events indicating if the file is loaded from the Media API

- include translations.properties file in the release distribution

## 2.1.0 (2016-12-07)

### Features

- integrators can specify a new fetchToken handler when instantiating Media Viewer,
  see [FIL-3298](https://jira.atlassian.com/browse/FIL-3298) for details.


## 2.0.1 (2016-11-10)

### Fixes

- **PDFViewer**: [FIL-3164](https://jira.atlassian.com/browse/FIL-3164) -  add cp-annotatable class for confluence-previews


## 2.0.0 (2016-08-01)

This release comes with two big changes to the project.

- First, we renamed File Viewer to Media Viewer to align the name with our other libraries.
- Second, we're now distributing Media Viewer via npm exclusively and dropped support for bower.

Apart from that Media Viewer comes with two new features and a ton of refactorings and code cleanups
that reduce the size of Media Viewer and thus improve the loading times. Furthermore, we added
webpack chunk splitting and removed our AUI/AJS dependency to provide an even faster experience to
our users.
   
### Features
 
- a new viewer for 3D files in the Sea3D format  
- a *beta* version of our new embeddable previews


## 1.4.6 (2016-05-25)

**This version can't be used for development**  
The `postinstall` script in `package.json` was removed to fix [FIL-2144 - FileViewer 1.4.5 breaks JIRA builds](https://jira.atlassian.com/browse/FIL-2144). This will be the last version 1.x.x release of FileViewer.

### Features

- **PDFViewer**: Update to PDFJS 1.5.188

### Fixes

- **PDFViewer**: [FIL-2040](https://jira.atlassian.com/browse/FIL-2040) - PDF viewer has rendering issues on retina screens
- **PDFViewer**: [FIL-2041](https://jira.atlassian.com/browse/FIL-2041) - PDF viewer doesn't render links anymore
- **PDFViewer**: [FIL-1947](https://jira.atlassian.com/browse/FIL-1947) - Parts of PDFS or whole PDFs are rendered too small
- **PDFViewer**: [FIL-1837](https://jira.atlassian.com/browse/FIL-1837) - JIRA PDF viewer doesn't show all details

## **UNPUBLISHED** - 1.4.5 (2016-05-24)

Due to causing build failures for JIRA FileViewer 1.4.5 had to be unpublished from npm.
[FIL-2144 - Installing FileViewer fails](https://jira.atlassian.com/browse/FIL-2144)

## 1.4.4 (2016-04-13)

### Features

- **PDFViewer**: [FIL-1796](https://jira.atlassian.com/browse/FIL-1796) - Update to PDFJS 1.4.229


## 1.4.3 (2016-03-15)

### Features

- **PDFViewer**: [FIL-1412](https://jira.atlassian.com/browse/FIL-1412) - Update to PDFJS 1.3.91

### Fixes
- **PDFViewer**: [FIL-1511](https://jira.atlassian.com/browse/FIL-1511) - Fix PDF links in presentation mode
- **PDFViewer**: [FIL-1515](https://jira.atlassian.com/browse/FIL-1515) - Fix text selection color in PDFs
- **PDFViewer**: [FIL-1403](https://jira.atlassian.com/browse/FIL-1403) - Fix PDF render issue on retina screens
- **FileViewer**: [FIL-1546](https://jira.atlassian.com/browse/FIL-1546) - Prevent FileViewer keyboard controls stealing user keyboard input in form elements
- **FileViewer**: [FIL-1542](https://jira.atlassian.com/browse/FIL-1542) - If a file has a `srcDownload` use that value in error messages instead of `src`


## **UNPUBLISHED** - 1.4.2 (2016-03-15)

Due to an unintended grunt release FileViewer 1.4.2 had to be unpublished from npm and as versions can't be overwritten in npm this version does not exist.


## 1.4.1 (2016-02-03)

### Fixes

- **MetaBar**: Fix typo in #_handleAvatarImageError()


## 1.4.0 (2016-02-03)

### Features

- **MetaBar**: [FIL-459](https://jira.atlassian.com/browse/FIL-459) Add MetaBar to show uploaders name, upload date and time, and file type and size information if available.


## 1.3.21 (2016-01-20)

### Fixes

- **FocusManager**: More defensive check if `hasAttribute` can be called.
- **FileViewer**: Replace A tag elements of navigation arrows with BUTTON elements.
  *Prevents page reloads when rapid clicking next/prev. It seems that rapid clicking fills the event queue to a point where `preventDefault` is ignored and the empty HREF reloads the page.*
- **ImageViewer**: Clear rescale interval on mode change to prevent multiple scale info overlay when rapidly changing modes
- **FileViewer**: [HC-24642](https://jira.atlassian.com/browse/HC-24642) Add `preventDefault` to arrow navigation to prevent system sound on HC Mac
- **FileViewer**: Add `data-fv-allow-focus` attribute to `moreButton` menu to enable interaction again


## 1.3.20 (2015-12-29)

### Fixes

- **VideoPlayer**: Resize player when MiniMode is toggled
- **ImageViewer**: Fix resizing when MiniMode is toggled


## 1.3.19 (2015-12-29)

### Fixes

- **MiniMode**: [FIL-1190](https://jira.atlassian.com/browse/FIL-1190) - Prevent default click event to stop MiniMode from altering the URL hash
- **VideoPlayer**: Stop play/pause button from stealing focus and by that breaking play/pause keyboard control


## 1.3.18 (2015-12-23)

### Features

- **FileViewer**: [FIL-1173](https://jira.atlassian.com/browse/FIL-1173) - Fixed interaction with elements outside of FileViewers main container (See [Plugin Development Guide](docs/plugin_guide.md))
- **MiniMode**: [FIL-1169](https://jira.atlassian.com/browse/FIL-1169) - Videos now autoplay when opened from the MiniMode

### Fixes

- **VideoPlayer**: [FIL-1174](https://jira.atlassian.com/browse/FIL-1174) - Fixed wrong state of play/pause button on player initialisation
- **VideoPlayer**: [FIL-1176](https://jira.atlassian.com/browse/FIL-1176) - Maintain the playing state of the video after SD/HD switch
- **VideoPlayer**: [FIL-1179](https://jira.atlassian.com/browse/FIL-1179) - Audio player now shows fallback cover if given poster src fails to load

## 1.3.17 (2015-12-21)

### Fixes

- **FileViewer**: Remove comparator from files model so file arrays will always be used in the order they were passed onto FileViewer


## 1.3.16 (2015-12-18)

### Fixes

- **VideoPlayer**: Return empty string for `poster` and `poster_hd` if their value is falsy


## 1.3.15 (2015-12-09)

### Fixes

- **VideoPlayer**: Fixed typo when calling #._restoreVideoPosterIfNotSet()


## 1.3.14 (2015-12-09)

### Features

- **VideoPlayer**: Use HD poster for videoplayer when showing the HD video

### Fixes

- **VideoPlayer**: Switch posters when switching SD/HD sources of the video


## 1.3.13 (2015-12-08)

### Fixes

- **VideoPlayer**: Update bower.json to use video.js 4.12.14 to enable the videoplayer switching between SD/HD even when the source has no filetype suffix
- **VideoPlayer**: Update the max size of videoplayer to 1280x720 instead of 960x540


## 1.3.12 (2015-11-26)

### Fixes

- **Toolbar**: [FIL-865](https://jira.atlassian.com/browse/FIL-865) - Fix issue where the toolbar sometimes didn't fade in again on mouse movement
- **ImageViewer**: Fix zoom scale overlay that when entering and exiting presentation mode rapidly displayed about 10 times

### Features

- **PDFViewer**: Update PdfJs to version 1.1.469

## 1.3.11 (2015-10-07)

### Fixes

- **Toolbar**: Prevent text selection on toolbar buttons
- **VideoPlayer**: [FIL-882](https://jira.atlassian.com/browse/FIL-882) - Fix issue where when closing FileViewer videojs throws an error for unsupported videos
- **Core**: Add method to viewer.registry to correctly check if video type can be played

## 1.3.10 (2015-08-13)

### Fixes

- **PDFViewer**: Fix missing $/jQuery definition in unknown-filetype.js
- **PDFViewer**: Fix missing $/jQuery definition in image-preloader.js plugin
- **VideoPlayer**: Prevent double-click to trigger YouTubes own fullscreen mode
- **VideoPlayer**: Fix issue where video sources where downloaded twice

## 1.3.9 (2015-08-13)

### Fixes

- **PDFViewer**: Fix PDFViewers missing $/jQuery definition in password-layer.js

## 1.3.8 (2015-08-07)

### Fixes

- **VideoPlayer**: [FIL-733](https://jira.atlassian.com/browse/FIL-733) - Fix videojs button addons for HC webclient

## 1.3.7 (2015-08-05)

### Fixes

- **VideoPlayer**: Fix presentation mode button for videoplayer

## 1.3.6 (2015-07-30)

### Fixes

- **VideoPlayer**: Fix issue where videoplayer would try to play HD version when none is available

## 1.3.5 (2015-07-29)

### Fixes

- **Core**: Fix keyboard navigation

## 1.3.4 (2015-07-28)

### Features

- **ImageViewer**: Browsers will no longer blur zoomed images if zooming is over 200%
- **ImageViewer**: Fit button will toggle between autoscale and 100%
- **ImageViewer**: Zooming images will show a overlay with the current zoom scale
- **Core**: Add ability to show a watermark image and bottom left corner
- **VideoPlayer**: Default to HD source if it is available

### Fixes

- **Core**: Fix AUI tooltips for controlbar and buttons
- **VideoPlayer**: Enable use of interactive elements in YouTube videos

## 1.3.3 (2015-07-07)

### Features

- **Core**: Add keyboard navigation

### Fixes

- **VideoPlayer**: Fix duplicated time tooltip after switching sources (SD/HD)
- **VideoPlayer**: Enable use of interactive elements in YouTube videos

## 1.3.2 (2015-06-17)

### Features

- **MainView**: Only re-render content if file src, type or thumbnail changes
- **FileViewer**: Create getCurrent() method that deprecates getCurrentFile()

## 1.3.1 (2015-06-17)

### Fixes

- **Build**: Include video player plugins into the build artifact

## 1.3.0 (2015-06-12)

### Features

- **Build**: Create minified versions of all build artifacts
- **Storage**: Add expire property to the key-value store and make sure it returns what we passed in
- **FileViewer**: Add FileViewer.setFiles() method
- **MainView**: MainView.showFiles() won't re-render if all attributes of the file are the same

### Chore

- **FileViewer**: Deprecate old FileViewer.showFile... methods

### Docs

- **FileViewer**: Update FileViewer jsdoc


## 1.2.2 (2015-05-20)

### Fixes

- **Core**: Don't switch files when along with the arrow keys modifier keys where pressed

## 1.2.1 (2015-05-11)

### Fixes

- **Image Viewer**: [FIL-555](https://jira.atlassian.com/browse/FIL-555) - Fix comment pins positioning
- **PDF Viewer**: [FIL-542](https://jira.atlassian.com/browse/FIL-542) - Center PDF pages in presentation mode
- **PDF Viewer**: [FIL-536](https://jira.atlassian.com/browse/FIL-536) - Maximum PDF width depends on wether or not the navigation arrows visible
- **Image Viewer**: Re-enable CSS image smoothing
- **PDF Viewer**: [FIL-539](https://jira.atlassian.com/browse/FIL-539) - Restore scroll functionality on parent page after fast exiting FileViewer from presentation mode
- **PDF Viewer**: Update PDFJS to 1.0.1040


## 1.2.0 (2015-04-30)

### Features

- **Config**: Move default config from `main-view.js` to `config.js`
- **Config**: Add config to disable navigation forward at the end and backward at the start of file list
Default: `enableListLoop: true`
- **Config**: Add config option to disable the presentation mode
Default: `enablePresentationMode: true`
- **Image Viewer**: Add image preloading plugin; Set the number of preloading images in `config.js`
Default: `preloadImagesAfterCurrent: 2`
Default: `preloadImagesBeforeCurrent: 0`
- **PDF Viewer**: Add support for password protected files
- **PDF Viewer**: New initial scale is 100% or `page-width` instead of `page-height`
- **PDF Viewer**: "Fit to width" button now toggles between last zoom scale and `page-width`

### Fixes

- **PDF Viewer**: Fix PDF rendering when elements where wrongly displayed with transparency
- **PDF Viewer**: Keep the document centered while zooming in
- **Image Viewer**: Add CSS to stop the image viewer from smoothing scaled up images
- **Image Viewer**: Replace checkered background for transparent images with a smaller pattern
- **Error Dialog**: Update all error and warning dialogs to match the "Unsupported" dialog
- **Waiting Dialog**: Replace download button with the default download button
- **Toolbar**: Stop toolbar from showing up on every file swich

## 1.1.0 (2015-04-20)

### Fixes

- **Presentation Mode**: Fix presentation mode file navigation issues
- **PDF Viewer**: Fix highlighted text in PDFs for IE
- **Image Viewer**: Fix centering of very wide images in image viewer

## 1.1.0-m5 (2015-03-10)

### Features

- **PDF Viewer**: Add `pdfTransportFactory` to enable consumers to directly pass data to PDFJS

### Fixes

- **Image Viewer**: Change background from white to checkered pattern for images
- **Assets**: Remove duplicate base64 svgs from file-types.less
- **Assets**: Extract data-uris from LESS files to image files that will be compiled later as data-uri
This will make editing image assets a lot easier.
- **Video Player**: Use v1.2.9 of youtube videojs plugin

## 1.1.0-m4 (2015-03-10)

### Features
- **Video Player**: Youtube button now continues at the current play position when opening the video on YouTube.com
- **Video Player**: Add HD/SD toggle button to videoplayer

### Fixes
- **Presentation Mode**: Store page scroll position when entering Presentation mode as Chrome scrolls to top after exiting fullscreen

## 1.1.0-m1 (2015-03-10)

### Features

- **Presentation Mode**: Add Presentation-Mode

## 1.0.2 (2015-03-03)

### Features

- **FileViewer**: add fileViewer.getFiles() method

### Fixes

- **Build**: add package.json back again

## 1.0.1 (2015-03-02)

### Fixes

- **bower_components**: Use public clone resource for youtube videojs plugin

## 1.0.0 (2015-03-02)

This is the first stable release of FileViewer. There's been tons of changes since its first beta
release. This release contains two major features: The audio/video player and the analytics module.
Additionally, some refactorings were introduced and a bunch of bugs have been fixed.

As this is the first stable release, there's not much of a changelog.

## Migration from 0.0.x to 0.1.x

### Directory Layout

The directory layout changed quite a lot and the new way of naming files is by using _ instead of -.

### FileViewer Exports & Modules

Starting from 01.x, FileViewer no longer exports its modules via AMD / require.js.
Instead it uses its own module loader (FileViewer.require / FileViewer.define). To
easier migrate here is a file that publishes all of those modules via AMD again.
Just add the following code to a new file and bundle it with the FileViewer resources.

    (function () {

        'use strict';


        var FileViewer = require('FileViewer');


        Object.keys(FileViewer._modules).forEach(function (module) {

            console.log(module);

            define(module, [], function () { return FileViewer.require(module); });

        });


    }());


### Internal Module Prefixes

The change above includes the removal of module prefixes 'cp/component/' and 'cp/previewers/'.
Also, the modules are now spelled like FileViewer instead of file-viewer.

### Template Prefix

Templates are no longer prefixed with ConfluencePreviews, but with FileViewer instead.
Therefore, we only expose a single global variable FileViewer.

### TemplateBackend

soyTemplateBackend is now included in core and the default backend. If no configuration
is given to fileViewer, soyTemplateBackend will be used.

### ModuleBackend
There is now a assetsModuleBackend in core (default), that expects all dependencies
to be included as static assets already. Configuration is loaded from
`fileViewer.getConfig().assets`.

### AppendTo config

If no config is given, FileViewer appends itself to the body element per default now.

### Analytics Events

A bunch of classes trigger no analytics events anymore:

- ArrowLayer
- DownloadButton

### FileViewer.showFile() is deprecated

This method was intended to be a public method, but right now it is used as an internal
function only, because it doesn't update the state anymore. DO NOT USE IT DIRECTLY.
Instead, use one of the many helpers.

### Viewer registration happens automatically

By default, all viewers are included now. If you only want a subset, pass an array with
the subset to the new FileViewer() config.

### Deleted Plugin CSS

Deleted a bunch of CSS that is non-core but was in core files (annotation css)

### Audio / Video player included

Additionally with support for youtube videos, if configured correctly (see demo)

### Minimode Plugin added to Core

First plugin that is considered to be part of core
If a file has a thumbnail this will be now be used - regardless of its type. Previously,
only images or converted files had thumbnails.

### File Downloads can be disabled

Just set downloadable = false [default = true] on a file to make the download button
disappear

### Removed Blue Bar on the very top

### ViewRegistrySingleton is gone

Use the property on fileViewer if you need access to it.

### Module Renamings
- ContentView now is called BaseViewer
- FileBodyView is now called ViewerLayer
- ErrorLayerView is now called ErrorLayer
- FileBodyArrowView is now called ArrowLayer
- FileBodySpinnerView is now called SpinnerLayer
- WaitingLayerView is now called WaitingLayer
- CloseButtonView is now called CloseButton
- DownloadButtonView is now called DownloadButton
- MoreButtonView is now called moreButton
- FileView is now called MainView
- FileTitleView is now called TitleView


### Toolbar Change

- The toolbar now has its own layer, lost some apis. Especially autoToggleControls is now gone.
- The toolbar now only shows after the viewer is ready
- Toolbar buttons are now properly centered
- Toolbar buttons are only shown if the viewer exposes the correct methods

### Tooltip Fix

All tooltips are now removed when the user changes the file or closes the viewer.

### FileVewer get() and set() methods

FileViewer has two new methods get() and set() intended to allow plugin developers to store values
on the instance.



### Layout Changes

main_view now consists of three wrapper elements with ids 'cp-header', 'cp-body' and 'cp-footer'.
Each one of those contains two collection views (a panel and a layer container view each).

### Footer Changes

$footer now contains two elements: a meta banner and a sink panel (minimode).
The meta banner is now part of the layout, but is hidden if there is now subview in it.
The minimode banner is NOT displaying itself anymore if a new file is added. That problem needs to
be addressed together with the arrow layers.

### Keys Util Module

There now is a keys module that can be required via 'keys' and exposes named keys.
MainView.KEYS doesn't exist anymore though.


### PDF Viewer config

be sure to set cMapUrl instead of "viewer" in the pdf-config (in module loader)
