define("cp/service/service-helpers", ["ajs"],
        function (AJS) {
            'use strict';

            var imageMimeTypes = [
                    "image/jpeg",
                    "image/jpg",
                    "image/gif",
                    "image/png",
                    "image/bmp",
                    "application/pdf",
                    "application/x-pdf"
            ];

            var contextPath = AJS.contextPath();

            var responseToFile = function (response) {
                if (response.id === -1) {
                    return {};
                }

                var contentType = response.contentType;
                var thumbnailPreview = response.previewContents.THUMBNAIL;
                var posterPreview = response.previewContents.POSTER;
                var documentPreview = response.previewContents.DOCUMENT;
                var documentHDPreview = response.previewContents.DOCUMENT_HD;
                var posterHDPreview = response.previewContents.POSTER_HD;

                var conversionsEnabled = AJS.DarkFeatures.isEnabled("previews.conversion-service");
                var thumbnailUrl = null;
                var srcUrl = null;
                var srcHDUrl = null;
                var posterUrl = null;
                var posterHDUrl = null;

                if (thumbnailPreview && conversionsEnabled) {
                    thumbnailUrl = contextPath + thumbnailPreview.downloadUrl;
                }

                if (posterPreview && conversionsEnabled) {
                    posterUrl = contextPath + posterPreview.downloadUrl;
                }
                // We want to use the original file for images & PDFs (because images will get converted to JPG,
                // which can look bad depending on the source), other files will use the converted path
                if (documentPreview && conversionsEnabled && imageMimeTypes.indexOf(contentType) < 0) {
                    srcUrl = contextPath + documentPreview.downloadUrl;
                    // We reset the content-type so the mediaviewer will poll for the conversion to be finished
                    contentType = "application/octet-stream";
                } else {
                    srcUrl = contextPath + response.downloadUrl
                }
                if (documentHDPreview && conversionsEnabled) {
                    srcHDUrl = contextPath + documentHDPreview.downloadUrl;
                }
                if (posterHDPreview && conversionsEnabled) {
                    posterHDUrl = contextPath + posterHDPreview.downloadUrl;
                }

                return {
                    src: srcUrl,
                    src_hd: srcHDUrl,
                    srcDownload: contextPath + response.downloadUrl + "&download=true",
                    type: contentType,
                    thumbnail: thumbnailUrl,
                    poster: posterUrl,
                    poster_hd: posterHDUrl,
                    title: response.fileName,
                    name: response.fileName,
                    id: response.id.toString(),
                    ownerId: response.containerId && response.containerId.toString(),
                    version: response.version,
                    hasReplyPermission: response.hasReplyPermission,
                    hasUploadAttachmentVersionPermission: response.hasUploadAttachmentVersionPermission
                };
            };

            return {
                responseToFile : responseToFile
            };
        }
);