define("cp/component/versions/versions",
    [
        "backbone"
    ],
    function(
        Backbone
    ) {
        "use strict";

        var Versions = Backbone.Collection.extend({
            model: function(attrs, options) {
                var Version = require("cp/component/versions/file-version");
                return new Version(attrs, {versionsService: options.collection.service, fileModel: options.collection.latestVersion});
            },
            initialize: function(attrs, opts) {
                this.service = opts.versionsService;
                this.latestVersion = opts.fileModel;
            },
            sync: function(method, collection) {
                if (!this.service) {
                    return;
                }

                if (method === "read") {
                    var versionsPromise =  this.service.getAllFileVersions(this.latestVersion.get('id'),
                                                                           this.latestVersion.get('ownerId'));

                    versionsPromise && versionsPromise.done(function(versions) {
                        collection.reset(versions, {silent: true});
                        collection.trigger("sync", collection);
                    });

                    return versionsPromise;
                }
            },
            fetchVersions: function(forceSync) {
                // Don't fetch again if we already have a list of comments.
                if (this.size() === 0 || forceSync) {
                    return this.fetch();
                } else {
                    return $.when();
                }
            }
        });

        return Versions;
    }
);