define("cp/component/versions/version-file-enricher",
    [
        "underscore",
        "cp/component/versions/versions",
        "cp/service/versions-service"
    ],
    function(
        _,
        Versions,
        VersionsService
        ) {
        "use strict";

        function enrich(file, version) {
            if (file.getLatestVersion) {
                return file;
            }

            var defaultMixin = {
                getLatestVersion: function() {
                    return this;
                },
                isLatestVersion: function() {
                    return true;
                }
            };

            var versionMixin = {
                getLatestVersion: function() {
                    return version.getLatestVersion();
                },
                isLatestVersion: function() {
                    return version.getLatestVersion() === this;
                }
            };

            _.extend(file, version ? versionMixin : defaultMixin);

            file.set('versions', new Versions([], {versionsService: new VersionsService(), fileModel: file.getLatestVersion()}));

            return file;
        }

        var VersionFileEnricher = {
            enrich: enrich
        };

        return VersionFileEnricher;
    }
);