define("cp/component/upload/upload-utils",
    [
        "underscore",
        "backbone",
        "cp/component/upload/upload-new-version-dialog-view",
        "cp/component/upload/attachment-uploader",
        "cp/service/upload-service"
    ],
    function (
        _,
        Backbone,
        UploadNewVersionDialogView,
        AttachmentUploader,
        UploadService
    ) {
        "use strict";

        var createUploader = function (mediaViewer, $triggerButton) {
            var uploadService = new UploadService(mediaViewer.getCurrentFile());

            var uploader = new AttachmentUploader(
                $triggerButton,
                $triggerButton,
                mediaViewer.getCurrentFile(),
                uploadService);

            uploader.on("cp.uploader.uploadStarted", function () {
                this.uploadNewVersionDialog = new UploadNewVersionDialogView({
                    uploader: uploader,
                    uploadService: uploadService,
                    mediaViewer: mediaViewer
                });
                this.uploadNewVersionDialog.render();
            });

            return uploader;
        };

        return {
            createUploader: createUploader
        };
});