define('cp/component/upload/upload-plugin', [
    'underscore',
    'MediaViewer',
    'cp/component/upload/upload-button-view'
], function (
    _,
    FileViewer,
    UploadButtonView
) {
    'use strict';

    var uploadPlugin = function (mediaViewer) {
        var controlsView = mediaViewer.getView().fileControlsView;

        // When upload new version of file => we need to refresh page to show new files
        var refreshIfFilesChanged = function () {
            mediaViewer._fileState.get('isNewFileUploaded') && document.location.reload(true);
        };

        var showsUploadButton = function () {
            var model = mediaViewer.getCurrentFile();
            return !$('#insert-image-dialog').is(':visible') && !model.get('isRemoteLink');
        };

        mediaViewer.close = _.wrap(mediaViewer.close, function (close) {
            close.apply(mediaViewer, Array.prototype.slice.call(arguments, 1));
            refreshIfFilesChanged();
        });

        controlsView.addLayerView('uploadButton', UploadButtonView, {
            predicate: showsUploadButton,
            weight: 40
        });
    };

    return uploadPlugin;
});

(function(){
    var UploadPlugin = require('cp/component/upload/upload-plugin');
    var MediaViewer = require('MediaViewer');
    MediaViewer.registerPlugin('upload', UploadPlugin);
})();