define('cp/component/permalink/permalink-plugin', [
    'MediaViewer',
    'cp/component/permalink/file-router'
], function (
    FileViewer,
    FileRouter
) {
    'use strict';

    var router;

    var permalinkPlugin = function (mediaViewer) {
        if (!mediaViewer.getConfig().enablePermalinks) { return; }
        router = new FileRouter({ mediaViewer: mediaViewer });
    };

    permalinkPlugin.setRoutingEnabled = function(enabled) {
        if (router) {
            router.setEnabled(enabled);
        }
    };

    permalinkPlugin.startRouting = function() {
        router.start();
    };

    permalinkPlugin.setRouteForPin = function(file, annotation) {
        if (router) {
            router._setRoute(file, annotation);
        }
    };

    return permalinkPlugin;
});

(function(){
    var PermalinkPlugin = require('cp/component/permalink/permalink-plugin');
    var MediaViewer = require('MediaViewer');
    MediaViewer.registerPlugin('permalink', PermalinkPlugin);
})();