define('cp/component/feature-discovery/feature-discovery-plugin', [
    'cp/component/feature-discovery/discovery-dialog',
    'underscore',
    'ajs',
    'confluence/legacy'
], function (
  DiscoveryDialog,
  _,
  AJS,
  Confluence
) {
    'use strict';

    var current = null;
    var featureDiscovery = Confluence.FeatureDiscovery.forPlugin("com.atlassian.confluence.plugins.confluence-previews");

    var closeOpenDialog = function(opt) {
        if (current === null) { return; }
        if (!opt.key || opt.key && current.is(opt.key)) {
            current.dismiss(opt.persist)
        }
    };

    var openDialog = function(opt) {
        var key = opt.key;
        var $anchor = $(opt.anchor);
        if ($anchor.length === 0
            || !$anchor.is(":visible")
            || $anchor.closest("body").length === 0
            || !featureDiscovery.shouldShow(key)) {
                return;
        }

        featureDiscovery.addDiscoveryView(opt.key);
        closeOpenDialog({persist: false});
        current = new DiscoveryDialog(opt);
        current.on('user-dismissed-dialog', function (key) {
            featureDiscovery.markDiscovered(key);
        });
        return current;
    };

    var featureDiscoveryPlugin = function (mediaViewer) {
        var remoteUser = AJS.Meta.get("remote-user");

        var viewAnnotationsKey = 'view-annotations';
        var addAnnotationKey = 'add-annotations';
        var featureKeys = [viewAnnotationsKey, addAnnotationKey];

        var shouldShow = remoteUser && _(featureKeys).without(featureDiscovery.listDiscovered()).length !== 0;
        if (!shouldShow) { return; }

        mediaViewer.on('fv.showFile', function (file) {
            closeOpenDialog({persist: false});
            var annotations = file.get("annotations");
            var isSupported = mediaViewer.supports(file.get("type"));
            var isRemoteLink = file.get('isRemoteLink');
            if (!annotations || !isSupported || isRemoteLink) { return; }

            var sidebarView = mediaViewer.getView().fileSidebarView;
            var controlsView = mediaViewer.getView().fileControlsView;
            var viewAnnotationButton = controlsView.getLayerForName('annotationButton');
            var currentViewer = mediaViewer.getView().fileContentView.getLayerForName("content")._viewer;

            annotations.on("sync", function () {
                var hasAnnotations = annotations.getCount();
                var isSidebarOpen = sidebarView.isPanelInitialized('annotations');

                if (hasAnnotations && !isSidebarOpen) {
                    openDialog({
                        key: viewAnnotationsKey,
                        anchor: viewAnnotationButton.$("a"),
                        text: AJS.I18n.getText("cp.feature.discovery.view.annotations.button"),
                        appendTo: mediaViewer.getView().$el
                    });
                } else {
                    var $annotateButton = currentViewer.$('#cp-file-control-annotate');

                    currentViewer.showControls();
                    var dialog = openDialog({
                        key: addAnnotationKey,
                        anchor: $annotateButton,
                        text: AJS.I18n.getText("cp.feature.discovery.annotate.button"),
                        appendTo: mediaViewer.getView().$el
                    });

                    if (dialog) {
                        currentViewer.autoToggleControls(false);
                        currentViewer.showControls();
                        $annotateButton.mousedown(function () {
                            closeOpenDialog({key: addAnnotationKey, persist: true});
                        });

                        dialog.on("hide", function() {
                            currentViewer.autoToggleControls(true);
                        });
                    }
                }
            });
        });

        mediaViewer.on('fv.changeFile fv.close', function () {
            closeOpenDialog({persist: false});
        });

        mediaViewer.getView().fileSidebarView.on('togglePanel', function (name, open) {
            if (name !== 'annotations' || open === false) { return; }
            closeOpenDialog({key: 'view-annotations', persist: true});
            closeOpenDialog({persist: false});
        });

        mediaViewer.getView().fileSinkView.on('togglePanel', function () {
            closeOpenDialog({persist: false});
        });
    };

    return featureDiscoveryPlugin;
});

(function(){
    var FeatureDiscoveryPlugin = require('cp/component/feature-discovery/feature-discovery-plugin');
    var MediaViewer = require('MediaViewer');
    MediaViewer.registerPlugin('featureDiscovery', FeatureDiscoveryPlugin);
})();