define(
    "cp/component/annotation/pins-view",
    [
        "backbone",
        "jquery",
        "underscore",
        "cp/component/annotation/comments",
        "cp/component/annotation/pin-view"
    ],
    function(
        Backbone,
        $,
        _,
        Comments,
        PinView
    ) {

        "use strict";

        var matches = function (properties) {
            return function (model) {
                for (var key in properties) {
                    if (properties[key] !== model.get(key)) {
                        return false;
                    }
                }
                return true;
            }
        };

        var PinsView = Backbone.View.extend({
            collection: Comments,

            initialize: function(props) {
                this.container = props.container;
                this.filter = props.filter;
                this.calculatePosition = props.calculatePosition;
                this.collection = props.collection;
                this.annotationPins = [];
                this._mediaViewer = props.mediaViewer;

                this.listenTo(this.collection, 'reset sync add remove', this.markRetrieved);
                this.listenTo(this.collection, 'reset sync add remove', this.render);
                this.listenTo(this.collection, 'filterUpdated', this.render);
            },

            markRetrieved: function () {
                // added for testability
                $(this.container).attr("data-pins-retrieved", true);
            },

            render: function() {
                // Remove any existing annotations on re-render.
                this.unbindAnnotationPins();

                var annotations = this.filter ? _.filter(this.collection.models, this.filter) : this.collection.models,
                    that = this;

                _.chain(annotations)
                    .filter(matches(this.collection.getFilter()))
                    .each(function(annotation) {
                        var pin = new PinView({
                            calculatePosition: that.calculatePosition,
                            model: annotation,
                            collection: that.collection,
                            mediaViewer: this._mediaViewer
                        });
                        that.annotationPins.push(pin);
                        $(pin.render().el).prependTo(that.container);
                    }, this);
            },

            unbindAnnotationPins: function() {
                while (this.annotationPins.length > 0) {
                    var annotation = this.annotationPins.pop();
                    annotation.remove().off();
                }
            },

            off: function(event, callback, context) {
                this.unbindAnnotationPins();
                return Backbone.Collection.prototype.off.call(this, event, callback, context);
            }
        });

        return PinsView;

    });

