define(
    "cp/component/annotation/likes-view",
    [
        "backbone",
        "jquery",
        "underscore",
        "ajs",
        "cp/component/annotation/comments",
        "MediaViewer",
        "cp/component/annotation/likes",
        "core/template-store-singleton"
    ],
    function(
        Backbone,
        $,
        _,
        AJS,
        Comments,
        FileViewer,
        Likes,
        templateStore
    ) {

        "use strict";
        var LikesView = Backbone.View.extend({
            collection: Likes,

            tagName: "span",

            className: "cp-annotation-like",

            events: {
                "click .cp-annotation-like": "like",
                "click .cp-annotation-unlike": "unlike"
            },

            initialize: function(props) {
                this.collection = props.collection;
                this.commentId = props.id;
                this._annotationView = props._annotationView;

                this.collection && this.listenTo(this.collection, 'reset add remove sync', this.render);

            },

            render: function() {
                this.$el.empty();

                if(this.collection === undefined) {
                    return;
                }

                //find the likes for this comment in our likes collection
                var commentLikes = _.find(this.collection.models, function(likes) {
                    return likes.attributes.content_id === this.commentId;
                }.bind(this));

                var isAnonymous = !(AJS.Meta.get('remote-user'));

                //check if this user has liked this comment
                var hasLiked = !isAnonymous && !!commentLikes && _.some(commentLikes.get('likes'), function(likedBy) {
                    return likedBy.user.name === AJS.Meta.get('remote-user');
                });

                var numberOfLikes = commentLikes ? commentLikes.get('likes').length : 0;

                this.$el.html(templateStore.get('Annotation.likes')({
                    likes: numberOfLikes,
                    hasLiked: hasLiked,
                    isAnonymous: isAnonymous
                }));
                return this;
            },

            like: function() {
                AJS.trigger('analyticsEvent', {
                    name: 'confluence-spaces.previews.annotation.like',
                    data: {
                        fileType: this._annotationView._mediaViewer.getCurrentFile().get("type"),
                        commentId: this.commentId
                    }
                });
                this.collection.addLike(this.commentId, {error: this._handleError.bind(this)});
            },

            unlike: function() {
                this.collection.removeLike(this.commentId);
            },

            _handleError: function() {
                this._annotationView._generateError(AJS.I18n.getText('cp.annotations.like.fail'));
            }
        });

        return LikesView;

    });

