define("cp/confluence/file-utils", ["underscore"],
        function (_) {
            'use strict';

            function matchId(file) {
                if (file.id && file.ownerId) {
                    return file.ownerId + "-" + file.id;
                }
                return file.src;
            }

            function deDupeFiles(files) {
                return _.uniq(files, matchId);
            }

            function mergeFiles(original, detailed) {
                var p = partition(detailed, function (key) {
                    return _.findWhere(original, {id: key.id})
                });

                var toMerge = p[0];
                var toAppend = p[1];

                var merged = _.map(original, function (originalFile) {
                    var fileToMerge = _.findWhere(toMerge, {id: originalFile.id});
                    return _.extend({}, originalFile, fileToMerge)
                });

                return deDupeFiles(merged.concat(toAppend))
            }

            function partition(list, predicate) {
                var not = function(value) { return !value };

                var left = list.filter(predicate);
                var right = list.filter(_.compose(not, predicate));

                return [left, right]
            }

            return {
                matchId : matchId,
                deDupeFiles : deDupeFiles,
                mergeFiles : mergeFiles,
                partition : partition
            }
        }
);