define('cp/component/companion/companion-file-jwt-service', [
        'jquery',
        'confluence/api/constants',
        'confluence/api/logger'
    ], function (
    $,
    CONSTANTS,
    logger
    ) {
        'use strict';

        var FileJWTService = {
            getContextPath: function () {
                try {
                    return CONSTANTS.CONTEXT_PATH;
                } catch (error) {
                    logger.warn('No context path found', error);
                    return '';
                }
            },
            /**
             *  Was a link signed with jwtId used in the last minute
             * @param jwtId
             * @param signal - used to cancel the request. see the AbortController API for more details
             * @returns {Promise<{isUsed: boolean}>} Promise of the result. Based on AbortController API - in case the signal was aborted
             *                              an error will be thrown with e.name==="AbortError"
             */
            fetchGetAttachmentUsageStatus: function (jwtId, signal) {
                return fetch(
                    CONSTANTS.CONTEXT_PATH +
                    '/rest/previews/templinksresource/companion/attachment-usage-status?jwtId=' +
                    jwtId,
                    {
                        signal: signal,
                        credentials: 'same-origin',
                        cache: 'no-store',
                    }
                ).then(function (response){ return response.json(); });
            },

            getTempFileContext: function (file) {
                var attachmentId = file.attributes.id;
                var pageId = file.attributes.ownerId;

                if (!attachmentId) {
                    return Promise.reject(new Error('FileJWTService.getTempFileContext: Unable to generate a download url without a valid attachmentId'));
                }

                if (!pageId) {
                    return Promise.reject(new Error('FileJWTService.getTempFileContext: Unable to generate a download url without a valid pageId'));
                }

                var promise = new Promise(function (resolve, reject) {
                    $.get(
                        CONSTANTS.CONTEXT_PATH +
                        '/rest/previews/templinksresource/companion/link' +
                        '?attachmentId=' + attachmentId +
                        '&pageId=' + pageId, undefined, undefined, "json"
                    ).done(function(data) {
                        resolve(data)
                    })
                        .fail(function (err) {
                            reject(err.responseText);
                        });
                });
                return promise;
            },
        };

        return FileJWTService;
    }
);


define('cp/component/companion/companion-service', [
        'ajs',
        'jquery',
        'cp/component/companion/companion-file-jwt-service'
    ], function (
    AJS,
    $,
    FileJWTService
    ) {
        'use strict';


        var createCompanionService = function (model) {
            var companionService = {
                model: model,

                getCompanionLaunchDetails: function () {
                    return FileJWTService.getTempFileContext(
                        this.model.get('file')
                    );
                },

                /**
                 *  run fetchGetAttachmentUsageStatus several times until you get a response with {isUsed: true}
                 * @param jwtId the jwt ID
                 * @param attempts number of attempts before resolving the returned promise with {isUsed: false}
                 * @param waitBeforeAttempt milliseconds to wait before each attempt to fetch
                 * @param signal created from AbortController to cancel the attempt
                 * @returns {Promise<never>|Promise<unknown>} a promise with the result
                 */
                getAttachmentUsageStatus: function (jwtId, attempts, waitBeforeAttempt, signal) {
                    return new Promise(function (resolve, reject) {
                        var currentAttempt = 0;
                        function runAttempt() {
                            currentAttempt++;
                            if (currentAttempt > attempts) {
                                return resolve({isUsed: false});
                            }
                            setTimeout(attempt, waitBeforeAttempt);
                        }

                        function attempt() {
                            // if the signal was aborted - the fetch will be canceled immediately
                            FileJWTService.fetchGetAttachmentUsageStatus(jwtId, signal)
                                .then(function (res) {
                                    if (res && res.isUsed) {
                                        resolve({isUsed: true});
                                    } else {
                                        runAttempt();
                                    }
                                })['catch'](function (e) {
                                    // if the request was aborted e.name==="AbortError"
                                    reject(e);
                                });
                        };
                        runAttempt();
                    });
                },
            };
            return companionService;
        };
        return createCompanionService;
    }
);
