define('cp/component/companion/companion-model', [
    'backbone',
    'confluence/meta'
], function(
    Backbone,
    Meta
) {
    'use strict';

    /**
     * Backbone model which represent the edit with state
     */
    var companionModel = Backbone.Model.extend({
        defaults: {
            file: undefined,
            siteTitle: undefined,
            isInternetConnected: true,
            isReadOnlyModeEnabled: false,
            hasMediaViewer: true
        },

        clear: function() {
            this.set({
                file: undefined,
                siteTitle: undefined,
                isInternetConnected: true
            });
        },

        getSiteTitle: function() {
            // Site title is displayed in Companion's
            var siteTitle = this.get('siteTitle');
            // If site title is empty we return default of "Confluence"
            if (siteTitle) {
                return siteTitle;
            }

            // Fallback to default if meta tag cannot be located
            siteTitle = Meta.get('site-title') || 'Confluence';
            this.set({ siteTitle: siteTitle });
            return siteTitle;
        }
    });

    return companionModel;
});
